/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.replication;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlyMultiRowPkReplicaRequest;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlyMultiRowPkReplicaRequestBuilder;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlyMultiRowPkReplicaRequestSerializer;
import org.apache.ignite3.internal.partition.replicator.network.replication.RequestType;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite3.internal.tostring.IgniteStringifier;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.tostring.SizeOnlyStringifier;

public class ReadOnlyMultiRowPkReplicaRequestImpl
implements ReadOnlyMultiRowPkReplicaRequest,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 8;
    @IgniteToStringInclude
    private final UUID coordinatorId;
    @IgniteToStringInclude
    private final ReplicationGroupIdMessage groupId;
    @IgniteStringifier(name="primaryKeys.size", value=SizeOnlyStringifier.class)
    private final List<ByteBuffer> primaryKeys;
    @IgniteToStringInclude
    private final HybridTimestamp readTimestamp;
    @IgniteToStringInclude
    private final RequestType requestType;
    @IgniteToStringInclude
    private final int schemaVersion;
    @IgniteToStringInclude
    private final int tableId;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;
    @IgniteToStringInclude
    private final UUID transactionId;
    @IgniteToStringInclude
    private final boolean usePrimary;

    private ReadOnlyMultiRowPkReplicaRequestImpl(UUID coordinatorId, ReplicationGroupIdMessage groupId, List<ByteBuffer> primaryKeys, HybridTimestamp readTimestamp, RequestType requestType, int schemaVersion, int tableId, HybridTimestamp timestamp, UUID transactionId, boolean usePrimary) {
        this.coordinatorId = coordinatorId;
        this.groupId = groupId;
        this.primaryKeys = primaryKeys;
        this.readTimestamp = readTimestamp;
        this.requestType = requestType;
        this.schemaVersion = schemaVersion;
        this.tableId = tableId;
        this.timestamp = timestamp;
        this.transactionId = transactionId;
        this.usePrimary = usePrimary;
    }

    @Override
    public UUID coordinatorId() {
        return this.coordinatorId;
    }

    @Override
    public ReplicationGroupIdMessage groupId() {
        return this.groupId;
    }

    @Override
    public List<ByteBuffer> primaryKeys() {
        return this.primaryKeys;
    }

    @Override
    public HybridTimestamp readTimestamp() {
        return this.readTimestamp;
    }

    @Override
    public RequestType requestType() {
        return this.requestType;
    }

    @Override
    public int schemaVersion() {
        return this.schemaVersion;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    @Override
    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    @Override
    public UUID transactionId() {
        return this.transactionId;
    }

    @Override
    public boolean usePrimary() {
        return this.usePrimary;
    }

    public MessageSerializer serializer() {
        return ReadOnlyMultiRowPkReplicaRequestSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(ReadOnlyMultiRowPkReplicaRequestImpl.class, this);
    }

    @Override
    public short messageType() {
        return 8;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ReadOnlyMultiRowPkReplicaRequestImpl otherMessage = (ReadOnlyMultiRowPkReplicaRequestImpl)other;
        return Objects.equals(this.coordinatorId, otherMessage.coordinatorId) && Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.primaryKeys, otherMessage.primaryKeys) && Objects.equals(this.readTimestamp, otherMessage.readTimestamp) && Objects.equals((Object)this.requestType, (Object)otherMessage.requestType) && Objects.equals(this.timestamp, otherMessage.timestamp) && Objects.equals(this.transactionId, otherMessage.transactionId) && this.schemaVersion == otherMessage.schemaVersion && this.tableId == otherMessage.tableId && this.usePrimary == otherMessage.usePrimary;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(new Object[]{this.schemaVersion, this.tableId, this.usePrimary, this.coordinatorId, this.groupId, this.primaryKeys, this.readTimestamp, this.requestType, this.timestamp, this.transactionId});
        return result;
    }

    @Override
    public ReadOnlyMultiRowPkReplicaRequestImpl clone() {
        try {
            return (ReadOnlyMultiRowPkReplicaRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ReadOnlyMultiRowPkReplicaRequestBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements ReadOnlyMultiRowPkReplicaRequestBuilder {
        private UUID coordinatorId;
        private ReplicationGroupIdMessage groupId;
        private List<ByteBuffer> primaryKeys;
        private HybridTimestamp readTimestamp;
        private RequestType requestType;
        private int schemaVersion;
        private int tableId;
        private HybridTimestamp timestamp;
        private UUID transactionId;
        private boolean usePrimary;

        private Builder() {
        }

        @Override
        public ReadOnlyMultiRowPkReplicaRequestBuilder coordinatorId(UUID coordinatorId) {
            this.coordinatorId = coordinatorId;
            return this;
        }

        @Override
        public ReadOnlyMultiRowPkReplicaRequestBuilder groupId(ReplicationGroupIdMessage groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public ReadOnlyMultiRowPkReplicaRequestBuilder primaryKeys(List<ByteBuffer> primaryKeys) {
            Objects.requireNonNull(primaryKeys, "primaryKeys is not marked @Nullable");
            this.primaryKeys = primaryKeys;
            return this;
        }

        @Override
        public ReadOnlyMultiRowPkReplicaRequestBuilder readTimestamp(HybridTimestamp readTimestamp) {
            Objects.requireNonNull(readTimestamp, "readTimestamp is not marked @Nullable");
            this.readTimestamp = readTimestamp;
            return this;
        }

        @Override
        public ReadOnlyMultiRowPkReplicaRequestBuilder requestType(RequestType requestType) {
            Objects.requireNonNull(requestType, "requestType is not marked @Nullable");
            this.requestType = requestType;
            return this;
        }

        @Override
        public ReadOnlyMultiRowPkReplicaRequestBuilder schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        public ReadOnlyMultiRowPkReplicaRequestBuilder tableId(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public ReadOnlyMultiRowPkReplicaRequestBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public ReadOnlyMultiRowPkReplicaRequestBuilder transactionId(UUID transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        @Override
        public ReadOnlyMultiRowPkReplicaRequestBuilder usePrimary(boolean usePrimary) {
            this.usePrimary = usePrimary;
            return this;
        }

        @Override
        public UUID coordinatorId() {
            return this.coordinatorId;
        }

        @Override
        public ReplicationGroupIdMessage groupId() {
            return this.groupId;
        }

        @Override
        public List<ByteBuffer> primaryKeys() {
            return this.primaryKeys;
        }

        @Override
        public HybridTimestamp readTimestamp() {
            return this.readTimestamp;
        }

        @Override
        public RequestType requestType() {
            return this.requestType;
        }

        @Override
        public int schemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public int tableId() {
            return this.tableId;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public UUID transactionId() {
            return this.transactionId;
        }

        @Override
        public boolean usePrimary() {
            return this.usePrimary;
        }

        @Override
        public ReadOnlyMultiRowPkReplicaRequest build() {
            return new ReadOnlyMultiRowPkReplicaRequestImpl(this.coordinatorId, Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), Objects.requireNonNull(this.primaryKeys, "primaryKeys is not marked @Nullable"), Objects.requireNonNull(this.readTimestamp, "readTimestamp is not marked @Nullable"), Objects.requireNonNull(this.requestType, "requestType is not marked @Nullable"), this.schemaVersion, this.tableId, this.timestamp, this.transactionId, this.usePrimary);
        }

        @Override
        public ReadOnlyMultiRowPkReplicaRequest buildDeserialized() {
            return new ReadOnlyMultiRowPkReplicaRequestImpl(this.coordinatorId, this.groupId, this.primaryKeys, this.readTimestamp, this.requestType, this.schemaVersion, this.tableId, this.timestamp, this.transactionId, this.usePrimary);
        }
    }
}

