/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.raft;

import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite3.internal.partition.replicator.network.raft.SnapshotTxDataResponse;
import org.apache.ignite3.internal.partition.replicator.network.raft.SnapshotTxDataResponseImpl;

class SnapshotTxDataResponseSerializer
implements MessageSerializer<SnapshotTxDataResponse> {
    public static final SnapshotTxDataResponseSerializer INSTANCE = new SnapshotTxDataResponseSerializer();

    private SnapshotTxDataResponseSerializer() {
    }

    @Override
    public boolean writeMessage(SnapshotTxDataResponse msg, MessageWriter writer) throws MessageMappingException {
        SnapshotTxDataResponseImpl message = (SnapshotTxDataResponseImpl)msg;
        writer.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.snapshotTxDataResponse());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)3)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeBoolean("finish", message.finish());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeList("txIds", message.txIds(), MessageCollectionItemType.UUID);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeList("txMeta", message.txMeta(), MessageCollectionItemType.MSG);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

