/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.raft;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.partition.replicator.network.raft.SnapshotTxDataResponse;
import org.apache.ignite3.internal.partition.replicator.network.raft.SnapshotTxDataResponseBuilder;
import org.apache.ignite3.internal.partition.replicator.network.raft.SnapshotTxDataResponseSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.tx.message.TxMetaMessage;

public class SnapshotTxDataResponseImpl
implements SnapshotTxDataResponse,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 16;
    @IgniteToStringInclude
    private final boolean finish;
    @IgniteToStringInclude
    private final List<UUID> txIds;
    @IgniteToStringInclude
    private final List<TxMetaMessage> txMeta;

    private SnapshotTxDataResponseImpl(boolean finish, List<UUID> txIds, List<TxMetaMessage> txMeta) {
        this.finish = finish;
        this.txIds = txIds;
        this.txMeta = txMeta;
    }

    @Override
    public boolean finish() {
        return this.finish;
    }

    @Override
    public List<UUID> txIds() {
        return this.txIds;
    }

    @Override
    public List<TxMetaMessage> txMeta() {
        return this.txMeta;
    }

    public MessageSerializer serializer() {
        return SnapshotTxDataResponseSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(SnapshotTxDataResponseImpl.class, this);
    }

    @Override
    public short messageType() {
        return 16;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SnapshotTxDataResponseImpl otherMessage = (SnapshotTxDataResponseImpl)other;
        return Objects.equals(this.txIds, otherMessage.txIds) && Objects.equals(this.txMeta, otherMessage.txMeta) && this.finish == otherMessage.finish;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.finish, this.txIds, this.txMeta);
        return result;
    }

    @Override
    public SnapshotTxDataResponseImpl clone() {
        try {
            return (SnapshotTxDataResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static SnapshotTxDataResponseBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.txMeta != null) {
            for (TxMetaMessage obj : this.txMeta) {
                if (obj == null) continue;
                obj.prepareMarshal(usedDescriptors, marshaller);
            }
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.txMeta != null) {
            for (TxMetaMessage obj : this.txMeta) {
                if (obj == null) continue;
                obj.unmarshal(marshaller, descriptorsObj);
            }
        }
    }

    private static class Builder
    implements SnapshotTxDataResponseBuilder {
        private boolean finish;
        private List<UUID> txIds;
        private List<TxMetaMessage> txMeta;

        private Builder() {
        }

        @Override
        public SnapshotTxDataResponseBuilder finish(boolean finish) {
            this.finish = finish;
            return this;
        }

        @Override
        public SnapshotTxDataResponseBuilder txIds(List<UUID> txIds) {
            Objects.requireNonNull(txIds, "txIds is not marked @Nullable");
            this.txIds = txIds;
            return this;
        }

        @Override
        public SnapshotTxDataResponseBuilder txMeta(List<TxMetaMessage> txMeta) {
            Objects.requireNonNull(txMeta, "txMeta is not marked @Nullable");
            this.txMeta = txMeta;
            return this;
        }

        @Override
        public boolean finish() {
            return this.finish;
        }

        @Override
        public List<UUID> txIds() {
            return this.txIds;
        }

        @Override
        public List<TxMetaMessage> txMeta() {
            return this.txMeta;
        }

        @Override
        public SnapshotTxDataResponse build() {
            return new SnapshotTxDataResponseImpl(this.finish, Objects.requireNonNull(this.txIds, "txIds is not marked @Nullable"), Objects.requireNonNull(this.txMeta, "txMeta is not marked @Nullable"));
        }

        @Override
        public SnapshotTxDataResponse buildDeserialized() {
            return new SnapshotTxDataResponseImpl(this.finish, this.txIds, this.txMeta);
        }
    }
}

