/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.disaster;

import java.util.UUID;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite3.internal.partition.replicator.network.disaster.OperationCompletedMessage;
import org.apache.ignite3.internal.partition.replicator.network.disaster.OperationCompletedMessageBuilder;

class OperationCompletedMessageDeserializer
implements MessageDeserializer<OperationCompletedMessage> {
    private final OperationCompletedMessageBuilder msg;

    OperationCompletedMessageDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.operationCompletedMessage();
    }

    @Override
    public Class<OperationCompletedMessage> klass() {
        return OperationCompletedMessage.class;
    }

    @Override
    public OperationCompletedMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.operationCompletedMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readString("exceptionMessage");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.exceptionMessage((String)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readUuid("operationId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.operationId((UUID)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(OperationCompletedMessage.class);
    }
}

