/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.persistence.compaction;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class CompactionMetricsTracker {
    private static final AtomicIntegerFieldUpdater<CompactionMetricsTracker> DATA_PAGES_WRITTEN_UPDATER = AtomicIntegerFieldUpdater.newUpdater(CompactionMetricsTracker.class, "dataPagesWritten");
    private static final AtomicIntegerFieldUpdater<CompactionMetricsTracker> DATA_PAGES_SKIPPED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(CompactionMetricsTracker.class, "dataPagesSkipped");
    private volatile int dataPagesWritten;
    private volatile int dataPagesSkipped;
    private final long startNanos = System.nanoTime();
    private long endNanos;

    public void onDataPageWritten() {
        DATA_PAGES_WRITTEN_UPDATER.incrementAndGet(this);
    }

    public void onPageSkipped() {
        DATA_PAGES_SKIPPED_UPDATER.incrementAndGet(this);
    }

    public void onCompactionEnd() {
        this.endNanos = System.nanoTime();
    }

    public int dataPagesWritten() {
        return this.dataPagesWritten;
    }

    public int dataPagesSkipped() {
        return this.dataPagesSkipped;
    }

    public long totalDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.endNanos - this.startNanos, TimeUnit.NANOSECONDS);
    }
}

