/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.persistence.checkpoint;

import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.ignite3.internal.logger.IgniteThrottledLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointReadWriteLockMetrics;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.IgniteCheckpointThread;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.ReentrantReadWriteLockWithTracking;
import org.jetbrains.annotations.Nullable;

public class CheckpointReadWriteLock {
    static final String CHECKPOINT_RUNNER_THREAD_PREFIX = "checkpoint-runner";
    private static final long LONG_LOCK_THRESHOLD_MILLIS = 1000L;
    private static final String LONG_LOCK_THROTTLE_KEY = "long-lock";
    private final IgniteThrottledLogger log;
    private final ThreadLocal<Long> checkpointReadLockAcquiredTime = new ThreadLocal();
    private final ThreadLocal<Integer> checkpointReadLockHoldCount = ThreadLocal.withInitial(() -> 0);
    private final ReentrantReadWriteLockWithTracking checkpointLock;
    private final CheckpointReadWriteLockMetrics metrics;
    @Nullable
    private volatile Thread currentWriteLockHolder;

    public CheckpointReadWriteLock(ReentrantReadWriteLockWithTracking checkpointLock, Executor throttledLogExecutor, CheckpointReadWriteLockMetrics metrics) {
        this.checkpointLock = checkpointLock;
        this.log = Loggers.toThrottledLogger(Loggers.forClass(CheckpointReadWriteLock.class), throttledLogExecutor);
        this.metrics = metrics;
    }

    public void readLock() {
        if (this.isWriteLockHeldByCurrentThread()) {
            return;
        }
        long startNanos = System.nanoTime();
        this.metrics.incrementReadLockWaitingThreads();
        this.checkpointLock.readLock().lock();
        this.onReadLock(startNanos, true);
    }

    public boolean tryReadLock(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.isWriteLockHeldByCurrentThread()) {
            return true;
        }
        long startNanos = System.nanoTime();
        this.metrics.incrementReadLockWaitingThreads();
        boolean res = this.checkpointLock.readLock().tryLock(timeout, unit);
        this.onReadLock(startNanos, res);
        return res;
    }

    public boolean tryReadLock() {
        if (this.isWriteLockHeldByCurrentThread()) {
            return true;
        }
        long startNanos = System.nanoTime();
        this.metrics.incrementReadLockWaitingThreads();
        boolean res = this.checkpointLock.readLock().tryLock();
        this.onReadLock(startNanos, res);
        return res;
    }

    public boolean checkpointLockIsHeldByThread() {
        return this.isWriteLockHeldByCurrentThread() || this.checkpointReadLockHoldCount.get() > 0 || Thread.currentThread() instanceof IgniteCheckpointThread;
    }

    public void readUnlock() {
        if (this.isWriteLockHeldByCurrentThread()) {
            return;
        }
        this.checkpointLock.readLock().unlock();
        this.onReadUnlock();
    }

    public void writeLock() {
        this.checkpointLock.writeLock().lock();
        this.currentWriteLockHolder = Thread.currentThread();
    }

    public void writeUnlock() {
        this.currentWriteLockHolder = null;
        this.checkpointLock.writeLock().unlock();
    }

    public boolean isWriteLockHeldByCurrentThread() {
        return this.currentWriteLockHolder == Thread.currentThread();
    }

    public int getReadHoldCount() {
        return this.checkpointLock.getReadHoldCount();
    }

    public boolean hasQueuedWriters() {
        return this.checkpointLock.hasQueuedWriters();
    }

    private void onReadLock(long startNanos, boolean taken) {
        long elapsedMillis;
        this.metrics.decrementReadLockWaitingThreads();
        long currentNanos = System.nanoTime();
        long elapsedNanos = currentNanos - startNanos;
        if (taken) {
            int newLockCount = this.checkpointReadLockHoldCount.get() + 1;
            this.checkpointReadLockHoldCount.set(newLockCount);
            if (newLockCount == 1) {
                this.checkpointReadLockAcquiredTime.set(currentNanos);
            }
            this.metrics.recordReadLockAcquisitionTime(elapsedNanos);
        }
        if ((elapsedMillis = TimeUnit.NANOSECONDS.toMillis(elapsedNanos)) > 1000L) {
            this.log.warn(LONG_LOCK_THROTTLE_KEY, "Checkpoint read lock took {} ms to acquire.", elapsedMillis);
        }
    }

    private void onReadUnlock() {
        int newLockCount = this.checkpointReadLockHoldCount.get() - 1;
        this.checkpointReadLockHoldCount.set(newLockCount);
        if (newLockCount == 0) {
            Long acquiredTimeNanos = this.checkpointReadLockAcquiredTime.get();
            long holdDurationNanos = System.nanoTime() - acquiredTimeNanos;
            this.metrics.recordReadLockHoldDuration(holdDurationNanos);
        }
    }
}

