/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.persistence.checkpoint;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.ignite3.internal.metrics.StopWatchTimer;
import org.apache.ignite3.internal.util.FastTimestamps;

public class CheckpointMetricsTracker {
    private static final AtomicIntegerFieldUpdater<CheckpointMetricsTracker> DATA_PAGES_WRITTEN_UPDATER = AtomicIntegerFieldUpdater.newUpdater(CheckpointMetricsTracker.class, "dataPagesWritten");
    private static final AtomicIntegerFieldUpdater<CheckpointMetricsTracker> COPY_ON_WRITE_PAGES_WRITTEN_UPDATER = AtomicIntegerFieldUpdater.newUpdater(CheckpointMetricsTracker.class, "copyOnWritePagesWritten");
    private volatile int dataPagesWritten;
    private volatile int copyOnWritePagesWritten;
    private final long startTimestamp = FastTimestamps.coarseCurrentTimeMillis();
    private final StopWatchTimer checkpointDuration = new StopWatchTimer();
    private final StopWatchTimer writeLockWaitDuration = new StopWatchTimer();
    private final StopWatchTimer onBeforeCheckpointBeginDuration = new StopWatchTimer();
    private final StopWatchTimer onMarkCheckpointBeginDuration = new StopWatchTimer();
    private final StopWatchTimer writeLockHoldDuration = new StopWatchTimer();
    private final StopWatchTimer pagesWriteDuration = new StopWatchTimer();
    private final StopWatchTimer fsyncDuration = new StopWatchTimer();
    private final StopWatchTimer replicatorLogSyncDuration = new StopWatchTimer();
    private final StopWatchTimer splitAndSortCheckpointPagesDuration = new StopWatchTimer();
    private final StopWatchTimer waitPageReplacement = new StopWatchTimer();

    public void onCopyOnWritePageWritten() {
        COPY_ON_WRITE_PAGES_WRITTEN_UPDATER.incrementAndGet(this);
    }

    public int copyOnWritePagesWritten() {
        return this.copyOnWritePagesWritten;
    }

    public void onDataPageWritten() {
        DATA_PAGES_WRITTEN_UPDATER.incrementAndGet(this);
    }

    public int dataPagesWritten() {
        return this.dataPagesWritten;
    }

    public long checkpointStartTime() {
        return this.startTimestamp;
    }

    public void onCheckpointStart() {
        this.checkpointDuration.start();
    }

    public void onCheckpointEnd() {
        this.checkpointDuration.end();
    }

    public long checkpointDuration(TimeUnit timeUnit) {
        return this.checkpointDuration.duration(timeUnit);
    }

    public void onWriteLockWaitStart() {
        this.writeLockWaitDuration.start();
    }

    public void onWriteLockWaitEnd() {
        this.writeLockWaitDuration.end();
    }

    public long writeLockWaitDuration(TimeUnit timeUnit) {
        return this.writeLockWaitDuration.duration(timeUnit);
    }

    public void onBeforeCheckpointBeginStart() {
        this.onBeforeCheckpointBeginDuration.start();
    }

    public void onBeforeCheckpointBeginEnd() {
        this.onBeforeCheckpointBeginDuration.end();
    }

    public long onBeforeCheckpointBeginDuration(TimeUnit timeUnit) {
        return this.onBeforeCheckpointBeginDuration.duration(timeUnit);
    }

    public void onMarkCheckpointBeginStart() {
        this.onMarkCheckpointBeginDuration.start();
    }

    public void onMarkCheckpointBeginEnd() {
        this.onMarkCheckpointBeginDuration.end();
    }

    public long onMarkCheckpointBeginDuration(TimeUnit timeUnit) {
        return this.onMarkCheckpointBeginDuration.duration(timeUnit);
    }

    public void onPagesWriteStart() {
        this.pagesWriteDuration.start();
    }

    public void onPagesWriteEnd() {
        this.pagesWriteDuration.end();
    }

    public long pagesWriteDuration(TimeUnit timeUnit) {
        return this.pagesWriteDuration.duration(timeUnit);
    }

    public void onFsyncStart() {
        this.fsyncDuration.start();
    }

    public void onFsyncEnd() {
        this.fsyncDuration.end();
    }

    public long fsyncDuration(TimeUnit timeUnit) {
        return this.fsyncDuration.duration(timeUnit);
    }

    public void onSplitAndSortCheckpointPagesStart() {
        this.splitAndSortCheckpointPagesDuration.start();
    }

    public void onSplitAndSortCheckpointPagesEnd() {
        this.splitAndSortCheckpointPagesDuration.end();
    }

    public long splitAndSortCheckpointPagesDuration(TimeUnit timeUnit) {
        return this.splitAndSortCheckpointPagesDuration.duration(timeUnit);
    }

    public void onReplicatorLogSyncStart() {
        this.replicatorLogSyncDuration.start();
    }

    public void onReplicatorLogSyncEnd() {
        this.replicatorLogSyncDuration.end();
    }

    public long replicatorLogSyncDuration(TimeUnit timeUnit) {
        return this.replicatorLogSyncDuration.duration(timeUnit);
    }

    public void onWriteLockHoldStart() {
        this.writeLockHoldDuration.start();
    }

    public void onWriteLockHoldEnd() {
        this.writeLockHoldDuration.end();
    }

    public long writeLockHoldDuration(TimeUnit timeUnit) {
        return this.writeLockHoldDuration.duration(timeUnit);
    }

    public long beforeWriteLockDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.writeLockWaitDuration.startNanos() - this.checkpointDuration.startNanos(), TimeUnit.NANOSECONDS);
    }

    public void onWaitPageReplacementStart() {
        this.waitPageReplacement.start();
    }

    public void onWaitPageReplacementEnd() {
        this.waitPageReplacement.end();
    }

    public long waitPageReplacementDuration(TimeUnit timeUnit) {
        return this.waitPageReplacement.duration(timeUnit);
    }
}

