/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.serialization.marshal;

class FlaggedObjectIds {
    private static final long LOWER_32_BITS_MASK = 0xFFFFFFFFL;

    FlaggedObjectIds() {
    }

    static long freshObjectId(int objectId) {
        return FlaggedObjectIds.flaggedObjectId(objectId, false);
    }

    static long alreadySeenObjectId(int objectId) {
        return FlaggedObjectIds.flaggedObjectId(objectId, true);
    }

    private static long flaggedObjectId(int objectId, boolean isAlreadySeen) {
        long longFlags = isAlreadySeen ? 1L : 0L;
        return (long)objectId & 0xFFFFFFFFL | longFlags << 32;
    }

    static int objectId(long flaggedObjectId) {
        return (int)(flaggedObjectId & 0xFFFFFFFFL);
    }

    static boolean isAlreadySeen(long flaggedObjectId) {
        int flags = (int)(flaggedObjectId >> 32);
        assert (flags == 0 || flags == 1) : flags;
        return flags != 0;
    }
}

