/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.recovery.message;

import java.util.UUID;
import org.apache.ignite3.internal.network.NetworkMessagesFactory;
import org.apache.ignite3.internal.network.NetworkMessagesTypeInfos;
import org.apache.ignite3.internal.network.message.ClusterNodeMessage;
import org.apache.ignite3.internal.network.recovery.message.HandshakeStartMessage;
import org.apache.ignite3.internal.network.recovery.message.HandshakeStartMessageBuilder;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class HandshakeStartMessageDeserializer
implements MessageDeserializer<HandshakeStartMessage> {
    private final HandshakeStartMessageBuilder msg;

    HandshakeStartMessageDeserializer(NetworkMessagesFactory messageFactory) {
        this.msg = messageFactory.handshakeStartMessage();
    }

    @Override
    public Class<HandshakeStartMessage> klass() {
        return HandshakeStartMessage.class;
    }

    @Override
    public HandshakeStartMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(NetworkMessagesTypeInfos.handshakeStartMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readString("productName");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.productName((String)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readString("productVersion");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.productVersion((String)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readUuid("serverClusterId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.serverClusterId((UUID)tmp);
                }
                reader.incrementState();
            }
            case 3: {
                Object tmp = (ClusterNodeMessage)reader.readMessage("serverNode");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.serverNode((ClusterNodeMessage)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(HandshakeStartMessage.class);
    }
}

