/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.recovery.message;

import org.apache.ignite3.internal.network.NetworkMessagesTypeInfos;
import org.apache.ignite3.internal.network.recovery.message.HandshakeRejectedMessage;
import org.apache.ignite3.internal.network.recovery.message.HandshakeRejectedMessageImpl;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;

class HandshakeRejectedMessageSerializer
implements MessageSerializer<HandshakeRejectedMessage> {
    public static final HandshakeRejectedMessageSerializer INSTANCE = new HandshakeRejectedMessageSerializer();

    private HandshakeRejectedMessageSerializer() {
    }

    @Override
    public boolean writeMessage(HandshakeRejectedMessage msg, MessageWriter writer) throws MessageMappingException {
        HandshakeRejectedMessageImpl message = (HandshakeRejectedMessageImpl)msg;
        writer.setMessageTypeInfo(NetworkMessagesTypeInfos.handshakeRejectedMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeString("message", message.message());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeString("reasonString", message.reasonString());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

