/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.message;

import org.apache.ignite3.internal.network.NetworkMessage;
import org.apache.ignite3.internal.network.NetworkMessagesFactory;
import org.apache.ignite3.internal.network.NetworkMessagesTypeInfos;
import org.apache.ignite3.internal.network.message.InvokeResponse;
import org.apache.ignite3.internal.network.message.InvokeResponseBuilder;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class InvokeResponseDeserializer
implements MessageDeserializer<InvokeResponse> {
    private final InvokeResponseBuilder msg;

    InvokeResponseDeserializer(NetworkMessagesFactory messageFactory) {
        this.msg = messageFactory.invokeResponse();
    }

    @Override
    public Class<InvokeResponse> klass() {
        return InvokeResponse.class;
    }

    @Override
    public InvokeResponse getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(NetworkMessagesTypeInfos.invokeResponse());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                long tmp = reader.readLong("correlationId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.correlationId(tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readMessage("message");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.message((NetworkMessage)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(InvokeResponse.class);
    }
}

