/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.dsl;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import org.apache.ignite3.internal.metastorage.dsl.Operation;
import org.apache.ignite3.internal.metastorage.dsl.StatementResult;
import org.apache.ignite3.internal.metastorage.dsl.Update;
import org.apache.ignite3.internal.metastorage.dsl.UpdateBuilder;
import org.apache.ignite3.internal.metastorage.dsl.UpdateSerializer;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class UpdateImpl
implements Update,
Cloneable {
    public static final short GROUP_TYPE = 222;
    public static final short TYPE = 7;
    @IgniteToStringInclude
    private final List<Operation> operations;
    @IgniteToStringInclude
    private final StatementResult result;

    private UpdateImpl(List<Operation> operations, StatementResult result) {
        this.operations = operations;
        this.result = result;
    }

    @Override
    public List<Operation> operations() {
        return this.operations;
    }

    @Override
    public StatementResult result() {
        return this.result;
    }

    public MessageSerializer serializer() {
        return UpdateSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 222;
    }

    public String toString() {
        return S.toString(UpdateImpl.class, this);
    }

    @Override
    public short messageType() {
        return 7;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        UpdateImpl otherMessage = (UpdateImpl)other;
        return Objects.equals(this.operations, otherMessage.operations) && Objects.equals(this.result, otherMessage.result);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.operations, this.result);
        return result;
    }

    @Override
    public UpdateImpl clone() {
        try {
            return (UpdateImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static UpdateBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.operations != null) {
            for (Operation obj : this.operations) {
                if (obj == null) continue;
                obj.prepareMarshal(usedDescriptors, marshaller);
            }
        }
        if (this.result != null) {
            this.result.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.operations != null) {
            for (Operation obj : this.operations) {
                if (obj == null) continue;
                obj.unmarshal(marshaller, descriptorsObj);
            }
        }
        if (this.result != null) {
            this.result.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements UpdateBuilder {
        private List<Operation> operations;
        private StatementResult result;

        private Builder() {
        }

        @Override
        public UpdateBuilder operations(List<Operation> operations) {
            Objects.requireNonNull(operations, "operations is not marked @Nullable");
            this.operations = operations;
            return this;
        }

        @Override
        public UpdateBuilder result(StatementResult result) {
            Objects.requireNonNull(result, "result is not marked @Nullable");
            this.result = result;
            return this;
        }

        @Override
        public List<Operation> operations() {
            return this.operations;
        }

        @Override
        public StatementResult result() {
            return this.result;
        }

        @Override
        public Update build() {
            return new UpdateImpl(Objects.requireNonNull(this.operations, "operations is not marked @Nullable"), Objects.requireNonNull(this.result, "result is not marked @Nullable"));
        }

        @Override
        public Update buildDeserialized() {
            return new UpdateImpl(this.operations, this.result);
        }
    }
}

