/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.command;

import org.apache.ignite3.internal.metastorage.command.MetaStorageCommandsTypeInfos;
import org.apache.ignite3.internal.metastorage.command.SyncTimeCommand;
import org.apache.ignite3.internal.metastorage.command.SyncTimeCommandImpl;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;

class SyncTimeCommandSerializer
implements MessageSerializer<SyncTimeCommand> {
    public static final SyncTimeCommandSerializer INSTANCE = new SyncTimeCommandSerializer();

    private SyncTimeCommandSerializer() {
    }

    @Override
    public boolean writeMessage(SyncTimeCommand msg, MessageWriter writer) throws MessageMappingException {
        SyncTimeCommandImpl message = (SyncTimeCommandImpl)msg;
        writer.setMessageTypeInfo(MetaStorageCommandsTypeInfos.syncTimeCommand());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)3)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeLong("initiatorTerm", message.initiatorTerm());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeHybridTimestamp("initiatorTime", message.initiatorTime());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeHybridTimestamp("safeTime", message.safeTime());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

