/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.command;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.metastorage.command.MetaStorageCommandsFactory;
import org.apache.ignite3.internal.metastorage.command.MetaStorageCommandsTypeInfos;
import org.apache.ignite3.internal.metastorage.command.RemoveByPrefixCommand;
import org.apache.ignite3.internal.metastorage.command.RemoveByPrefixCommandBuilder;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class RemoveByPrefixCommandDeserializer
implements MessageDeserializer<RemoveByPrefixCommand> {
    private final RemoveByPrefixCommandBuilder msg;

    RemoveByPrefixCommandDeserializer(MetaStorageCommandsFactory messageFactory) {
        this.msg = messageFactory.removeByPrefixCommand();
    }

    @Override
    public Class<RemoveByPrefixCommand> klass() {
        return RemoveByPrefixCommand.class;
    }

    @Override
    public RemoveByPrefixCommand getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(MetaStorageCommandsTypeInfos.removeByPrefixCommand());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Comparable<HybridTimestamp> tmp = reader.readHybridTimestamp("initiatorTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.initiatorTime((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Comparable<HybridTimestamp> tmp = reader.readByteBuffer("prefix");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.prefix((ByteBuffer)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Comparable<HybridTimestamp> tmp = reader.readHybridTimestamp("safeTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.safeTime((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RemoveByPrefixCommand.class);
    }
}

