/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.command;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.metastorage.command.MetaStorageCommandsFactory;
import org.apache.ignite3.internal.metastorage.command.MetaStorageCommandsTypeInfos;
import org.apache.ignite3.internal.metastorage.command.RemoveAllCommand;
import org.apache.ignite3.internal.metastorage.command.RemoveAllCommandBuilder;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class RemoveAllCommandDeserializer
implements MessageDeserializer<RemoveAllCommand> {
    private final RemoveAllCommandBuilder msg;

    RemoveAllCommandDeserializer(MetaStorageCommandsFactory messageFactory) {
        this.msg = messageFactory.removeAllCommand();
    }

    @Override
    public Class<RemoveAllCommand> klass() {
        return RemoveAllCommand.class;
    }

    @Override
    public RemoveAllCommand getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(MetaStorageCommandsTypeInfos.removeAllCommand());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                HybridTimestamp tmp = reader.readHybridTimestamp("initiatorTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.initiatorTime(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                HybridTimestamp tmp = reader.readList("keys", MessageCollectionItemType.BYTE_BUFFER);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.keys((List<ByteBuffer>)((Object)tmp));
                }
                reader.incrementState();
            }
            case 2: {
                HybridTimestamp tmp = reader.readHybridTimestamp("safeTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.safeTime(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RemoveAllCommand.class);
    }
}

