/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.command;

import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.metastorage.command.CompactionCommand;
import org.apache.ignite3.internal.metastorage.command.CompactionCommandBuilder;
import org.apache.ignite3.internal.metastorage.command.MetaStorageCommandsFactory;
import org.apache.ignite3.internal.metastorage.command.MetaStorageCommandsTypeInfos;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class CompactionCommandDeserializer
implements MessageDeserializer<CompactionCommand> {
    private final CompactionCommandBuilder msg;

    CompactionCommandDeserializer(MetaStorageCommandsFactory messageFactory) {
        this.msg = messageFactory.compactionCommand();
    }

    @Override
    public Class<CompactionCommand> klass() {
        return CompactionCommand.class;
    }

    @Override
    public CompactionCommand getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(MetaStorageCommandsTypeInfos.compactionCommand());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                long tmp = reader.readLong("compactionRevision");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.compactionRevision(tmp);
                reader.incrementState();
            }
            case 1: {
                HybridTimestamp tmp = reader.readHybridTimestamp("initiatorTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.initiatorTime(tmp);
                }
                reader.incrementState();
            }
            case 2: {
                HybridTimestamp tmp = reader.readHybridTimestamp("safeTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.safeTime(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(CompactionCommand.class);
    }
}

