/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage;

import java.util.UUID;
import org.apache.ignite3.internal.metastorage.CommandId;
import org.apache.ignite3.internal.metastorage.CommandIdBuilder;
import org.apache.ignite3.internal.metastorage.dsl.MetaStorageMessagesFactory;
import org.apache.ignite3.internal.metastorage.dsl.MetaStorageMessagesTypeInfos;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class CommandIdDeserializer
implements MessageDeserializer<CommandId> {
    private final CommandIdBuilder msg;

    CommandIdDeserializer(MetaStorageMessagesFactory messageFactory) {
        this.msg = messageFactory.commandId();
    }

    @Override
    public Class<CommandId> klass() {
        return CommandId.class;
    }

    @Override
    public CommandId getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(MetaStorageMessagesTypeInfos.commandId());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                long tmp = reader.readLong("counter");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.counter(tmp);
                reader.incrementState();
            }
            case 1: {
                UUID tmp = reader.readUuid("nodeId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.nodeId(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(CommandId.class);
    }
}

