/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.marshaller;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.marshaller.BinaryMode;
import org.apache.ignite3.internal.marshaller.MarshallerColumn;
import org.apache.ignite3.internal.marshaller.MarshallerReader;
import org.apache.ignite3.internal.marshaller.MarshallerWriter;
import org.apache.ignite3.internal.marshaller.ValidationUtils;
import org.apache.ignite3.lang.MarshallerException;
import org.apache.ignite3.table.mapper.TypeConverter;
import org.jetbrains.annotations.Nullable;

abstract class FieldAccessor {
    private final BinaryMode mode;
    private final int colIdx;
    private final int scale;
    private String columnName;

    FieldAccessor withColumnName(String columnName) {
        this.columnName = columnName;
        return this;
    }

    String getColumnName() {
        return this.columnName;
    }

    static FieldAccessor noopAccessor(MarshallerColumn col) {
        return new UnmappedFieldAccessor(col);
    }

    static FieldAccessor create(Class<?> type, String fldName, MarshallerColumn col, int colIdx, @Nullable TypeConverter<?, ?> typeConverter) {
        try {
            Field field = type.getDeclaredField(fldName);
            if (typeConverter == null) {
                ValidationUtils.validateColumnType(col, field.getType());
            }
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(type, MethodHandles.lookup());
            VarHandle varHandle = lookup.unreflectVarHandle(field);
            if (typeConverter == null && field.getType().isPrimitive()) {
                BinaryMode fieldAccessMode = BinaryMode.forClass(field.getType());
                assert (fieldAccessMode != null) : "Invalid fieldAccessMode for type: " + field.getType();
                switch (fieldAccessMode) {
                    case P_BOOLEAN: {
                        return new BooleanPrimitiveAccessor(varHandle, colIdx);
                    }
                    case P_BYTE: {
                        return new BytePrimitiveAccessor(varHandle, colIdx);
                    }
                    case P_SHORT: {
                        return new ShortPrimitiveAccessor(varHandle, colIdx);
                    }
                    case P_INT: {
                        return new IntPrimitiveAccessor(varHandle, colIdx);
                    }
                    case P_LONG: {
                        return new LongPrimitiveAccessor(varHandle, colIdx);
                    }
                    case P_FLOAT: {
                        return new FloatPrimitiveAccessor(varHandle, colIdx);
                    }
                    case P_DOUBLE: {
                        return new DoublePrimitiveAccessor(varHandle, colIdx);
                    }
                }
                assert (false) : "Invalid field access mode " + fieldAccessMode;
                throw new IllegalArgumentException("Failed to create accessor for field [name=" + field.getName() + "]");
            }
            return new ReferenceFieldAccessor(varHandle, colIdx, col.type(), col.scale(), typeConverter);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    static IdentityAccessor createIdentityAccessor(MarshallerColumn col, int colIdx, @Nullable TypeConverter<?, ?> converter) {
        switch (col.type()) {
            case P_BOOLEAN: 
            case P_BYTE: 
            case P_SHORT: 
            case P_INT: 
            case P_LONG: 
            case P_FLOAT: 
            case P_DOUBLE: {
                throw new IllegalArgumentException("Primitive key/value types are not possible by API contract.");
            }
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case UUID: 
            case BYTE_ARR: 
            case DECIMAL: 
            case TIME: 
            case DATE: 
            case DATETIME: 
            case TIMESTAMP: 
            case POJO: {
                return new IdentityAccessor(colIdx, col.type(), col.scale(), converter);
            }
        }
        assert (false) : "Invalid mode " + col.type();
        throw new IllegalArgumentException("Failed to create accessor for column [name=" + col.name() + "]");
    }

    FieldAccessor(int colIdx, BinaryMode mode, int scale) {
        assert (colIdx >= 0);
        this.colIdx = colIdx;
        this.mode = mode;
        this.scale = scale;
    }

    FieldAccessor(int colIdx, BinaryMode mode) {
        this(colIdx, mode, 0);
    }

    Object readRefValue(MarshallerReader reader) {
        assert (reader != null);
        assert (this.colIdx >= 0);
        switch (this.mode) {
            case BOOLEAN: {
                return reader.readBooleanBoxed();
            }
            case BYTE: {
                return reader.readByteBoxed();
            }
            case SHORT: {
                return reader.readShortBoxed();
            }
            case INT: {
                return reader.readIntBoxed();
            }
            case LONG: {
                return reader.readLongBoxed();
            }
            case FLOAT: {
                return reader.readFloatBoxed();
            }
            case DOUBLE: {
                return reader.readDoubleBoxed();
            }
            case STRING: {
                return reader.readString();
            }
            case UUID: {
                return reader.readUuid();
            }
            case BYTE_ARR: {
                return reader.readBytes();
            }
            case DECIMAL: {
                return reader.readBigDecimal(this.scale);
            }
            case DATE: {
                return reader.readDate();
            }
            case TIME: {
                return reader.readTime();
            }
            case TIMESTAMP: {
                return reader.readTimestamp();
            }
            case DATETIME: {
                return reader.readDateTime();
            }
            case POJO: {
                return reader.readBytes();
            }
        }
        throw new IllegalArgumentException("Invalid mode: " + this.mode);
    }

    void writeRefObject(Object val, MarshallerWriter writer) {
        assert (writer != null);
        if (val == null) {
            writer.writeNull();
            return;
        }
        switch (this.mode) {
            case BOOLEAN: {
                writer.writeBoolean((Boolean)val);
                break;
            }
            case BYTE: {
                writer.writeByte((Byte)val);
                break;
            }
            case SHORT: {
                writer.writeShort((Short)val);
                break;
            }
            case INT: {
                writer.writeInt((Integer)val);
                break;
            }
            case LONG: {
                writer.writeLong((Long)val);
                break;
            }
            case FLOAT: {
                writer.writeFloat(((Float)val).floatValue());
                break;
            }
            case DOUBLE: {
                writer.writeDouble((Double)val);
                break;
            }
            case STRING: {
                writer.writeString((String)val);
                break;
            }
            case UUID: {
                writer.writeUuid((UUID)val);
                break;
            }
            case BYTE_ARR: {
                writer.writeBytes((byte[])val);
                break;
            }
            case DECIMAL: {
                writer.writeBigDecimal((BigDecimal)val, this.scale);
                break;
            }
            case DATE: {
                writer.writeDate((LocalDate)val);
                break;
            }
            case TIME: {
                writer.writeTime((LocalTime)val);
                break;
            }
            case TIMESTAMP: {
                writer.writeTimestamp((Instant)val);
                break;
            }
            case DATETIME: {
                writer.writeDateTime((LocalDateTime)val);
                break;
            }
            case POJO: {
                writer.writeBytes((byte[])val);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid mode: " + this.mode);
            }
        }
    }

    final void write(MarshallerWriter writer, @Nullable Object obj) throws MarshallerException {
        try {
            this.write0(writer, obj);
        }
        catch (Exception ex) {
            throw new MarshallerException(ex.getMessage(), (Throwable)ex);
        }
    }

    abstract void write0(MarshallerWriter var1, @Nullable Object var2) throws Exception;

    final void read(MarshallerReader reader, Object obj) throws MarshallerException {
        try {
            this.read0(reader, obj);
        }
        catch (Exception ex) {
            throw new MarshallerException(ex.getMessage(), (Throwable)ex);
        }
    }

    abstract Object read(MarshallerReader var1);

    void read0(MarshallerReader reader, Object obj) {
        Object val = this.read(reader);
        this.set(obj, val);
    }

    abstract Object value(Object var1);

    abstract void set(Object var1, Object var2);

    private static class UnmappedFieldAccessor
    extends FieldAccessor {
        private final MarshallerColumn col;

        UnmappedFieldAccessor(MarshallerColumn col) {
            super(0, null);
            this.col = col;
        }

        @Override
        Object read(MarshallerReader reader) throws MarshallerException {
            reader.skipValue();
            return null;
        }

        @Override
        void read0(MarshallerReader reader, Object obj) {
            this.read(reader);
        }

        @Override
        void write0(MarshallerWriter writer, Object obj) {
            writer.writeAbsentValue();
        }

        @Override
        Object value(Object obj) {
            return this.col.defaultValue();
        }

        @Override
        void set(Object obj, Object val) {
        }
    }

    private static class BooleanPrimitiveAccessor
    extends VarHandleAccessor {
        BooleanPrimitiveAccessor(VarHandle varHandle, int colIdx) {
            super(colIdx, BinaryMode.P_BOOLEAN, varHandle);
        }

        @Override
        void write0(MarshallerWriter writer, Object obj) {
            boolean val = (Boolean)this.get(obj);
            writer.writeBoolean(val);
        }

        @Override
        Object read(MarshallerReader reader) {
            return reader.readBoolean();
        }
    }

    private static class BytePrimitiveAccessor
    extends VarHandleAccessor {
        BytePrimitiveAccessor(VarHandle varHandle, int colIdx) {
            super(colIdx, BinaryMode.P_BYTE, varHandle);
        }

        @Override
        void write0(MarshallerWriter writer, Object obj) {
            byte val = (Byte)this.get(obj);
            writer.writeByte(val);
        }

        @Override
        Object read(MarshallerReader reader) {
            return reader.readByte();
        }
    }

    private static class ShortPrimitiveAccessor
    extends VarHandleAccessor {
        ShortPrimitiveAccessor(VarHandle varHandle, int colIdx) {
            super(colIdx, BinaryMode.P_SHORT, varHandle);
        }

        @Override
        void write0(MarshallerWriter writer, Object obj) {
            short val = (Short)this.get(obj);
            writer.writeShort(val);
        }

        @Override
        Object read(MarshallerReader reader) {
            return reader.readShort();
        }
    }

    private static class IntPrimitiveAccessor
    extends VarHandleAccessor {
        IntPrimitiveAccessor(VarHandle varHandle, int colIdx) {
            super(colIdx, BinaryMode.P_INT, varHandle);
        }

        @Override
        void write0(MarshallerWriter writer, Object obj) {
            int val = (Integer)this.get(obj);
            writer.writeInt(val);
        }

        @Override
        Object read(MarshallerReader reader) {
            return reader.readInt();
        }
    }

    private static class LongPrimitiveAccessor
    extends VarHandleAccessor {
        LongPrimitiveAccessor(VarHandle varHandle, int colIdx) {
            super(colIdx, BinaryMode.P_LONG, varHandle);
        }

        @Override
        void write0(MarshallerWriter writer, Object obj) {
            long val = (Long)this.get(obj);
            writer.writeLong(val);
        }

        @Override
        Object read(MarshallerReader reader) {
            return reader.readLong();
        }
    }

    private static class FloatPrimitiveAccessor
    extends VarHandleAccessor {
        FloatPrimitiveAccessor(VarHandle varHandle, int colIdx) {
            super(colIdx, BinaryMode.P_FLOAT, varHandle);
        }

        @Override
        void write0(MarshallerWriter writer, Object obj) {
            float val = ((Float)this.get(obj)).floatValue();
            writer.writeFloat(val);
        }

        @Override
        Object read(MarshallerReader reader) {
            return Float.valueOf(reader.readFloat());
        }
    }

    private static class DoublePrimitiveAccessor
    extends VarHandleAccessor {
        DoublePrimitiveAccessor(VarHandle varHandle, int colIdx) {
            super(colIdx, BinaryMode.P_DOUBLE, varHandle);
        }

        @Override
        void write0(MarshallerWriter writer, Object obj) {
            double val = (Double)this.get(obj);
            writer.writeDouble(val);
        }

        @Override
        Object read(MarshallerReader reader) {
            return reader.readDouble();
        }
    }

    private static class ReferenceFieldAccessor
    extends VarHandleAccessor {
        @Nullable
        private final TypeConverter<Object, Object> typeConverter;

        ReferenceFieldAccessor(VarHandle varHandle, int colIdx, BinaryMode mode, int scale, @Nullable TypeConverter<?, ?> typeConverter) {
            super(colIdx, mode, scale, varHandle);
            this.typeConverter = typeConverter;
        }

        @Override
        void write0(MarshallerWriter writer, @Nullable Object obj) {
            assert (writer != null);
            if (obj == null) {
                writer.writeNull();
                return;
            }
            Object val = this.get(obj);
            if (val == null) {
                writer.writeNull();
                return;
            }
            try {
                this.writeRefObject(this.typeConverter == null ? val : this.typeConverter.toColumnType(val), writer);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        Object read(MarshallerReader reader) {
            Object val = this.readRefValue(reader);
            try {
                return this.typeConverter == null ? val : this.typeConverter.toObjectType(val);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        Object value(Object obj) {
            Object value = this.get(Objects.requireNonNull(obj));
            try {
                return this.typeConverter == null ? value : this.typeConverter.toColumnType(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public static class IdentityAccessor
    extends FieldAccessor {
        @Nullable
        private final TypeConverter<Object, Object> converter;

        IdentityAccessor(int colIdx, BinaryMode mode, int scale, @Nullable TypeConverter<?, ?> converter) {
            super(colIdx, mode, scale);
            this.converter = converter;
        }

        @Override
        void write0(MarshallerWriter writer, Object obj) {
            try {
                obj = this.converter == null ? obj : this.converter.toColumnType(obj);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            this.writeRefObject(obj, writer);
        }

        @Override
        void read0(MarshallerReader reader, Object obj) {
            throw new UnsupportedOperationException("Called identity accessor for object field.");
        }

        @Override
        Object read(MarshallerReader reader) {
            Object obj = this.readRefValue(reader);
            try {
                return this.converter == null ? obj : this.converter.toObjectType(obj);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        Object value(Object obj) {
            return obj;
        }

        @Override
        void set(Object obj, Object val) {
            throw new UnsupportedOperationException("Called identity accessor for object field.");
        }
    }

    static abstract class VarHandleAccessor
    extends FieldAccessor {
        private final VarHandle varHandle;

        VarHandleAccessor(int colIdx, BinaryMode mode, VarHandle varHandle) {
            super(colIdx, mode);
            this.varHandle = varHandle;
        }

        VarHandleAccessor(int colIdx, BinaryMode mode, int scale, VarHandle varHandle) {
            super(colIdx, mode, scale);
            this.varHandle = varHandle;
        }

        <T> T get(Object obj) {
            return (T)this.varHandle.get(obj);
        }

        @Override
        void set(Object obj, Object val) {
            try {
                this.varHandle.set(obj, val);
            }
            catch (Exception ex) {
                throw new MarshallerException(ex.getMessage(), (Throwable)ex);
            }
        }

        @Override
        Object value(Object obj) {
            return this.get(Objects.requireNonNull(obj));
        }
    }
}

