/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.jdbc;

import java.sql.SQLException;
import org.apache.ignite3.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteException;

final class JdbcExceptionMapperUtil {
    private static final String TX_CONTROL_STATEMENT_WHEN_AUTOCOMMIT_MODE_OFF = "Transaction control statements are not supported when autocommit mode is disabled.";

    private JdbcExceptionMapperUtil() {
    }

    static SQLException mapToJdbcException(String message, Exception e) {
        return new SQLException(message, IgniteExceptionMapperUtil.mapToPublicException(ExceptionUtils.unwrapCause(e)));
    }

    static SQLException mapToJdbcException(Exception e) {
        IgniteException ie;
        Throwable cause = IgniteExceptionMapperUtil.mapToPublicException(ExceptionUtils.unwrapCause(e));
        String message = cause.getMessage();
        if (cause instanceof IgniteException && (ie = (IgniteException)cause).code() == ErrorGroups.Sql.TX_CONTROL_INSIDE_EXTERNAL_TX_ERR) {
            message = TX_CONTROL_STATEMENT_WHEN_AUTOCOMMIT_MODE_OFF;
        }
        return new SQLException(message, cause);
    }
}

