/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.apache.ignite3.internal.client.proto.ProtocolVersion;
import org.apache.ignite3.internal.jdbc.JdbcUtils;
import org.apache.ignite3.internal.jdbc.proto.IgniteQueryErrorCode;
import org.apache.ignite3.internal.jdbc.proto.JdbcDatabaseMetadataHandler;
import org.apache.ignite3.internal.jdbc.proto.event.JdbcColumnMeta;
import org.apache.ignite3.internal.jdbc.proto.event.JdbcMetaColumnsRequest;
import org.apache.ignite3.internal.jdbc.proto.event.JdbcMetaColumnsResult;
import org.apache.ignite3.internal.jdbc.proto.event.JdbcMetaPrimaryKeysRequest;
import org.apache.ignite3.internal.jdbc.proto.event.JdbcMetaPrimaryKeysResult;
import org.apache.ignite3.internal.jdbc.proto.event.JdbcMetaSchemasRequest;
import org.apache.ignite3.internal.jdbc.proto.event.JdbcMetaSchemasResult;
import org.apache.ignite3.internal.jdbc.proto.event.JdbcMetaTablesRequest;
import org.apache.ignite3.internal.jdbc.proto.event.JdbcMetaTablesResult;
import org.apache.ignite3.internal.jdbc.proto.event.JdbcPrimaryKeyMeta;
import org.apache.ignite3.internal.jdbc.proto.event.JdbcTableMeta;
import org.apache.ignite3.internal.properties.IgniteProductVersion;
import org.apache.ignite3.internal.sql.ColumnMetadataImpl;
import org.apache.ignite3.sql.ColumnMetadata;
import org.apache.ignite3.sql.ColumnType;

public class JdbcDatabaseMetadata
implements DatabaseMetaData {
    public static final String DRIVER_NAME = "Apache Ignite JDBC Driver";
    public static final String PRODUCT_NAME = "Apache Ignite";
    public static final String CATALOG_NAME = "IGNITE";
    public static final String TYPE_TABLE = "TABLE";
    public static final String TYPE_VIEW = "VIEW";
    private final JdbcDatabaseMetadataHandler handler;
    private final String url;
    private final String userName;
    private final Connection connection;
    private final Supplier<ZoneId> timeZoneSupplier;

    public JdbcDatabaseMetadata(Connection connection, JdbcDatabaseMetadataHandler handler, String url, String userName, Supplier<ZoneId> timeZoneSupplier) {
        this.handler = handler;
        this.connection = connection;
        this.url = url;
        this.userName = userName;
        this.timeZoneSupplier = timeZoneSupplier;
    }

    @Override
    public boolean allProceduresAreCallable() {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return true;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return true;
    }

    @Override
    public String getDatabaseProductName() {
        return PRODUCT_NAME;
    }

    @Override
    public String getDatabaseProductVersion() {
        return ProtocolVersion.LATEST_VER.toString();
    }

    @Override
    public String getDriverName() {
        return DRIVER_NAME;
    }

    @Override
    public String getDriverVersion() {
        return IgniteProductVersion.CURRENT_VERSION.toString();
    }

    @Override
    public int getDriverMajorVersion() {
        return IgniteProductVersion.CURRENT_VERSION.major();
    }

    @Override
    public int getDriverMinorVersion() {
        return IgniteProductVersion.CURRENT_VERSION.minor();
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public String getIdentifierQuoteString() {
        return "\"";
    }

    @Override
    public String getSQLKeywords() {
        return "";
    }

    @Override
    public String getNumericFunctions() {
        return "";
    }

    @Override
    public String getStringFunctions() {
        return "";
    }

    @Override
    public String getSystemFunctions() {
        return "";
    }

    @Override
    public String getTimeDateFunctions() {
        return "";
    }

    @Override
    public String getSearchStringEscape() {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return true;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    @Override
    public String getSchemaTerm() {
        return "schema";
    }

    @Override
    public String getProcedureTerm() {
        return "";
    }

    @Override
    public String getCatalogTerm() {
        return "";
    }

    @Override
    public boolean isCatalogAtStart() {
        return false;
    }

    @Override
    public String getCatalogSeparator() {
        return "";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 128;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 0;
    }

    @Override
    public int getMaxConnections() {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 0;
    }

    @Override
    public int getMaxIndexLength() {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 128;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 0;
    }

    @Override
    public int getMaxRowSize() {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return false;
    }

    @Override
    public int getMaxStatementLength() {
        return 0;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() {
        return 0;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 8;
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) {
        return level == 8;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPtrn, String procedureNamePtrn) throws SQLException {
        this.ensureNotClosed();
        return JdbcUtils.createObjectListResultSet(Arrays.asList(JdbcDatabaseMetadata.columnMeta("PROCEDURE_CAT", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("PROCEDURE_SCHEM", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("PROCEDURE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("", ColumnType.NULL), JdbcDatabaseMetadata.columnMeta("", ColumnType.NULL), JdbcDatabaseMetadata.columnMeta("", ColumnType.NULL), JdbcDatabaseMetadata.columnMeta("REMARKS", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("PROCEDURE_TYPE", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("SPECIFIC_NAME", ColumnType.STRING)));
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPtrn, String procedureNamePtrn, String colNamePtrn) throws SQLException {
        this.ensureNotClosed();
        return JdbcUtils.createObjectListResultSet(Arrays.asList(JdbcDatabaseMetadata.columnMeta("PROCEDURE_CAT", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("PROCEDURE_SCHEM", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("PROCEDURE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("COLUMN_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("COLUMN_TYPE", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("DATA_TYPE", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("TYPE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("PRECISION", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("LENGTH", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("SCALE", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("RADIX", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("NULLABLE", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("REMARKS", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("COLUMN_DEF", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("SQL_DATA_TYPE", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("SQL_DATETIME_SUB", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("CHAR_OCTET_LENGTH", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("ORDINAL_POSITION", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("IS_NULLABLE", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("SPECIFIC_NAME", ColumnType.STRING)));
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPtrn, String tblNamePtrn, String[] tblTypes) throws SQLException {
        this.ensureNotClosed();
        List<ColumnMetadata> meta = Arrays.asList(JdbcDatabaseMetadata.columnMeta("TABLE_CAT", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TABLE_SCHEM", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TABLE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TABLE_TYPE", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("REMARKS", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TYPE_CAT", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TYPE_SCHEM", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TYPE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("SELF_REFERENCING_COL_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("REF_GENERATION", ColumnType.STRING));
        boolean tblTypeMatch = false;
        if (tblTypes == null) {
            tblTypeMatch = true;
        } else {
            for (String type : tblTypes) {
                if (!TYPE_TABLE.equals(type) && !TYPE_VIEW.equals(type)) continue;
                tblTypeMatch = true;
                break;
            }
        }
        if (!JdbcDatabaseMetadata.isValidCatalog(catalog) || !tblTypeMatch) {
            return JdbcUtils.createObjectListResultSet(meta);
        }
        try {
            JdbcMetaTablesResult res = this.handler.tablesMetaAsync(new JdbcMetaTablesRequest(schemaPtrn, tblNamePtrn, tblTypes)).get();
            if (!res.success()) {
                throw IgniteQueryErrorCode.createJdbcSqlException(res.err(), res.status());
            }
            LinkedList<List<Object>> rows = new LinkedList<List<Object>>();
            for (JdbcTableMeta tblMeta : res.meta()) {
                rows.add(this.tableRow(tblMeta));
            }
            return JdbcUtils.createObjectListResultSet(rows, meta, this.timeZoneSupplier);
        }
        catch (InterruptedException e) {
            throw new SQLException("Thread was interrupted.", e);
        }
        catch (ExecutionException e) {
            throw new SQLException("Metadata request failed.", e);
        }
        catch (CancellationException e) {
            throw new SQLException("Metadata request canceled.", "57014");
        }
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, "%");
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPtrn) throws SQLException {
        this.ensureNotClosed();
        List<ColumnMetadata> meta = Arrays.asList(JdbcDatabaseMetadata.columnMeta("TABLE_SCHEM", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TABLE_CATALOG", ColumnType.STRING));
        if (!JdbcDatabaseMetadata.isValidCatalog(catalog)) {
            return JdbcUtils.createObjectListResultSet(meta);
        }
        try {
            JdbcMetaSchemasResult res = this.handler.schemasMetaAsync(new JdbcMetaSchemasRequest(schemaPtrn)).get();
            if (!res.success()) {
                throw IgniteQueryErrorCode.createJdbcSqlException(res.err(), res.status());
            }
            LinkedList<List<Object>> rows = new LinkedList<List<Object>>();
            for (String schema : res.schemas()) {
                ArrayList<String> row = new ArrayList<String>(2);
                row.add(schema);
                row.add(CATALOG_NAME);
                rows.add(row);
            }
            return JdbcUtils.createObjectListResultSet(rows, meta, this.timeZoneSupplier);
        }
        catch (InterruptedException e) {
            throw new SQLException("Thread was interrupted.", e);
        }
        catch (ExecutionException e) {
            throw new SQLException("Metadata request failed.", e);
        }
        catch (CancellationException e) {
            throw new SQLException("Metadata request canceled.", e);
        }
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        this.ensureNotClosed();
        return JdbcUtils.createObjectListResultSet(Collections.singletonList(Collections.singletonList(CATALOG_NAME)), Arrays.asList(JdbcDatabaseMetadata.columnMeta("TABLE_CAT", ColumnType.STRING)), this.timeZoneSupplier);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        this.ensureNotClosed();
        return JdbcUtils.createObjectListResultSet(Arrays.asList(List.of(TYPE_TABLE), List.of(TYPE_VIEW)), Arrays.asList(JdbcDatabaseMetadata.columnMeta("TABLE_TYPE", ColumnType.STRING)), this.timeZoneSupplier);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPtrn, String tblNamePtrn, String colNamePtrn) throws SQLException {
        this.ensureNotClosed();
        List<ColumnMetadata> meta = Arrays.asList(JdbcDatabaseMetadata.columnMeta("TABLE_CAT", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TABLE_SCHEM", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TABLE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("COLUMN_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("DATA_TYPE", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("TYPE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("COLUMN_SIZE", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("BUFFER_LENGTH", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("DECIMAL_DIGITS", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("NUM_PREC_RADIX", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("NULLABLE", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("REMARKS", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("COLUMN_DEF", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("SQL_DATA_TYPE", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("SQL_DATETIME_SUB", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("CHAR_OCTET_LENGTH", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("ORDINAL_POSITION", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("IS_NULLABLE", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("SCOPE_CATLOG", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("SCOPE_SCHEMA", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("SCOPE_TABLE", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("SOURCE_DATA_TYPE", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("IS_AUTOINCREMENT", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("IS_GENERATEDCOLUMN", ColumnType.STRING));
        if (!JdbcDatabaseMetadata.isValidCatalog(catalog)) {
            return JdbcUtils.createObjectListResultSet(meta);
        }
        try {
            JdbcMetaColumnsResult res = this.handler.columnsMetaAsync(new JdbcMetaColumnsRequest(schemaPtrn, tblNamePtrn, colNamePtrn)).get();
            if (!res.success()) {
                throw IgniteQueryErrorCode.createJdbcSqlException(res.err(), res.status());
            }
            LinkedList<List<Object>> rows = new LinkedList<List<Object>>();
            for (int i = 0; i < res.meta().size(); ++i) {
                rows.add(JdbcDatabaseMetadata.columnRow(res.meta().get(i), i + 1));
            }
            return JdbcUtils.createObjectListResultSet(rows, meta, this.timeZoneSupplier);
        }
        catch (InterruptedException e) {
            throw new SQLException("Thread was interrupted.", e);
        }
        catch (ExecutionException e) {
            throw new SQLException("Metadata request failed.", e);
        }
        catch (CancellationException e) {
            throw new SQLException("Metadata request canceled.", "57014");
        }
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String tbl, String colNamePtrn) throws SQLException {
        this.ensureNotClosed();
        return JdbcUtils.createObjectListResultSet(Arrays.asList(JdbcDatabaseMetadata.columnMeta("TABLE_CAT", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TABLE_SCHEM", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TABLE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("COLUMN_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("GRANTOR", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("GRANTEE", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("PRIVILEGE", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("IS_GRANTABLE", ColumnType.STRING)));
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPtrn, String tblNamePtrn) throws SQLException {
        this.ensureNotClosed();
        return JdbcUtils.createObjectListResultSet(Arrays.asList(JdbcDatabaseMetadata.columnMeta("TABLE_CAT", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TABLE_SCHEM", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TABLE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("GRANTOR", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("GRANTEE", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("PRIVILEGE", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("IS_GRANTABLE", ColumnType.STRING)));
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String tbl, int scope, boolean nullable) throws SQLException {
        return JdbcUtils.createObjectListResultSet(Arrays.asList(JdbcDatabaseMetadata.columnMeta("SCOPE", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("COLUMN_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("DATA_TYPE", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("TYPE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("COLUMN_SIZE", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("BUFFER_LENGTH", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("DECIMAL_DIGITS", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("PSEUDO_COLUMN", ColumnType.INT16)));
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String tbl) throws SQLException {
        this.ensureNotClosed();
        return JdbcUtils.createObjectListResultSet(Arrays.asList(JdbcDatabaseMetadata.columnMeta("SCOPE", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("COLUMN_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("DATA_TYPE", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("TYPE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("COLUMN_SIZE", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("BUFFER_LENGTH", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("DECIMAL_DIGITS", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("PSEUDO_COLUMN", ColumnType.INT16)));
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String tbl) throws SQLException {
        this.ensureNotClosed();
        List<ColumnMetadata> meta = Arrays.asList(JdbcDatabaseMetadata.columnMeta("TABLE_CAT", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TABLE_SCHEM", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TABLE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("COLUMN_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("KEY_SEQ", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("PK_NAME", ColumnType.STRING));
        if (!JdbcDatabaseMetadata.isValidCatalog(catalog)) {
            return JdbcUtils.createObjectListResultSet(meta);
        }
        try {
            JdbcMetaPrimaryKeysResult res = this.handler.primaryKeysMetaAsync(new JdbcMetaPrimaryKeysRequest(schema, tbl)).get();
            if (!res.success()) {
                throw IgniteQueryErrorCode.createJdbcSqlException(res.err(), res.status());
            }
            LinkedList<List<Object>> rows = new LinkedList<List<Object>>();
            for (JdbcPrimaryKeyMeta pkMeta : res.meta()) {
                rows.addAll(JdbcDatabaseMetadata.primaryKeyRows(pkMeta));
            }
            return JdbcUtils.createObjectListResultSet(rows, meta, this.timeZoneSupplier);
        }
        catch (InterruptedException e) {
            throw new SQLException("Thread was interrupted.", e);
        }
        catch (ExecutionException e) {
            throw new SQLException("Metadata request failed.", e);
        }
        catch (CancellationException e) {
            throw new SQLException("Metadata request canceled.", "57014");
        }
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String tbl) throws SQLException {
        this.ensureNotClosed();
        return JdbcUtils.createObjectListResultSet(Arrays.asList(JdbcDatabaseMetadata.columnMeta("PKTABLE_CAT", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("PKTABLE_SCHEM", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("PKTABLE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("PKCOLUMN_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("FKTABLE_CAT", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("FKTABLE_SCHEM", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("FKTABLE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("FKCOLUMN_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("KEY_SEQ", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("UPDATE_RULE", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("DELETE_RULE", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("FK_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("PK_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("DEFERRABILITY", ColumnType.INT16)));
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String tbl) throws SQLException {
        this.ensureNotClosed();
        return JdbcUtils.createObjectListResultSet(Arrays.asList(JdbcDatabaseMetadata.columnMeta("PKTABLE_CAT", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("PKTABLE_SCHEM", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("PKTABLE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("PKCOLUMN_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("FKTABLE_CAT", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("FKTABLE_SCHEM", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("FKTABLE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("FKCOLUMN_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("KEY_SEQ", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("UPDATE_RULE", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("DELETE_RULE", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("FK_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("PK_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("DEFERRABILITY", ColumnType.INT16)));
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTbl, String foreignCatalog, String foreignSchema, String foreignTbl) throws SQLException {
        this.ensureNotClosed();
        return JdbcUtils.createObjectListResultSet(Arrays.asList(JdbcDatabaseMetadata.columnMeta("PKTABLE_CAT", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("PKTABLE_SCHEM", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("PKTABLE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("PKCOLUMN_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("FKTABLE_CAT", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("FKTABLE_SCHEM", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("FKTABLE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("FKCOLUMN_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("KEY_SEQ", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("UPDATE_RULE", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("DELETE_RULE", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("FK_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("PK_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("DEFERRABILITY", ColumnType.INT16)));
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        this.ensureNotClosed();
        ArrayList<List<Object>> types = new ArrayList<List<Object>>(21);
        types.add(Arrays.asList("BOOLEAN", 16, 1, null, null, null, (short)1, false, (short)3, false, false, false, "BOOLEAN", 0, 0, 16, 0, 10));
        types.add(Arrays.asList("TINYINT", -6, 3, null, null, null, (short)1, false, (short)3, false, false, false, "TINYINT", 0, 0, -6, 0, 10));
        types.add(Arrays.asList("SMALLINT", 5, 5, null, null, null, (short)1, false, (short)3, false, false, false, "SMALLINT", 0, 0, 5, 0, 10));
        types.add(Arrays.asList("INTEGER", 4, 10, null, null, null, (short)1, false, (short)3, false, false, false, "INTEGER", 0, 0, 4, 0, 10));
        types.add(Arrays.asList("BIGINT", -5, 19, null, null, null, (short)1, false, (short)3, false, false, false, "BIGINT", 0, 0, -5, 0, 10));
        types.add(Arrays.asList("FLOAT", 6, 17, null, null, null, (short)1, false, (short)3, false, false, false, "FLOAT", 0, 0, 6, 0, 10));
        types.add(Arrays.asList("REAL", 7, 7, null, null, null, (short)1, false, (short)3, false, false, false, "REAL", 0, 0, 7, 0, 10));
        types.add(Arrays.asList("DOUBLE", 8, 17, null, null, null, (short)1, false, (short)3, false, false, false, "DOUBLE", 0, 0, 8, 0, 10));
        types.add(Arrays.asList("NUMERIC", 2, Integer.MAX_VALUE, null, null, "PRECISION,SCALE", (short)1, false, (short)3, false, false, false, "NUMERIC", 0, 0, 2, 0, 10));
        types.add(Arrays.asList("DECIMAL", 3, Integer.MAX_VALUE, null, null, "PRECISION,SCALE", (short)1, false, (short)3, false, false, false, "DECIMAL", 0, 0, 3, 0, 10));
        types.add(Arrays.asList("DATE", 91, 8, "DATE '", "'", null, (short)1, false, (short)3, false, false, false, "DATE", 0, 0, 91, 0, null));
        types.add(Arrays.asList("TIME", 92, 6, "TIME '", "'", null, (short)1, false, (short)3, false, false, false, "TIME", 0, 0, 92, 0, null));
        types.add(Arrays.asList("TIMESTAMP", 93, 23, "TIMESTAMP '", "'", null, (short)1, false, (short)3, false, false, false, "TIMESTAMP", 0, 10, 93, 0, null));
        types.add(Arrays.asList("CHAR", 1, Integer.MAX_VALUE, "'", "'", "LENGTH", (short)1, true, (short)3, false, false, false, "CHAR", 0, 0, 1, 0, null));
        types.add(Arrays.asList("VARCHAR", 12, Integer.MAX_VALUE, "'", "'", "LENGTH", (short)1, true, (short)3, false, false, false, "VARCHAR", 0, 0, 12, 0, null));
        types.add(Arrays.asList("LONGVARCHAR", -1, Integer.MAX_VALUE, "'", "'", "LENGTH", (short)1, true, (short)3, false, false, false, "LONGVARCHAR", 0, 0, -1, 0, null));
        types.add(Arrays.asList("BINARY", -2, Integer.MAX_VALUE, "'", "'", "LENGTH", (short)1, false, (short)3, false, false, false, "BINARY", 0, 0, -2, 0, null));
        types.add(Arrays.asList("VARBINARY", -3, Integer.MAX_VALUE, "'", "'", "LENGTH", (short)1, false, (short)3, false, false, false, "VARBINARY", 0, 0, -3, 0, null));
        types.add(Arrays.asList("LONGVARBINARY", -4, Integer.MAX_VALUE, "'", "'", "LENGTH", (short)1, false, (short)3, false, false, false, "LONGVARBINARY", 0, 0, -4, 0, null));
        types.add(Arrays.asList("UUID", 1111, -1, "'", "'", null, (short)1, false, (short)3, true, false, false, null, 0, 0, 1111, null, 10));
        types.add(Arrays.asList("OTHER", 1111, Integer.MAX_VALUE, "'", "'", "LENGTH", (short)1, false, (short)3, false, false, false, "OTHER", 0, 0, 1111, 0, null));
        types.add(Arrays.asList("ARRAY", 2003, 0, "(", "')", null, (short)1, false, (short)3, false, false, false, "ARRAY", 0, 0, 2003, 0, null));
        return JdbcUtils.createObjectListResultSet(types, Arrays.asList(JdbcDatabaseMetadata.columnMeta("TYPE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("DATA_TYPE", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("PRECISION", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("LITERAL_PREFIX", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("LITERAL_SUFFIX", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("CREATE_PARAMS", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("NULLABLE", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("CASE_SENSITIVE", ColumnType.BOOLEAN), JdbcDatabaseMetadata.columnMeta("SEARCHABLE", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("UNSIGNED_ATTRIBUTE", ColumnType.BOOLEAN), JdbcDatabaseMetadata.columnMeta("FIXED_PREC_SCALE", ColumnType.BOOLEAN), JdbcDatabaseMetadata.columnMeta("AUTO_INCREMENT", ColumnType.BOOLEAN), JdbcDatabaseMetadata.columnMeta("LOCAL_TYPE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("MINIMUM_SCALE", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("MAXIMUM_SCALE", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("SQL_DATA_TYPE", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("SQL_DATETIME_SUB", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("NUM_PREC_RADIX", ColumnType.INT32)), this.timeZoneSupplier);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String tbl, boolean unique, boolean approximate) throws SQLException {
        this.ensureNotClosed();
        List<ColumnMetadata> meta = Arrays.asList(JdbcDatabaseMetadata.columnMeta("TABLE_CAT", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TABLE_SCHEM", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TABLE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("NON_UNIQUE", ColumnType.BOOLEAN), JdbcDatabaseMetadata.columnMeta("INDEX_QUALIFIER", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("INDEX_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TYPE", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("ORDINAL_POSITION", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("COLUMN_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("ASC_OR_DESC", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("CARDINALITY", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("PAGES", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("FILTER_CONDITION", ColumnType.STRING));
        if (!JdbcDatabaseMetadata.isValidCatalog(catalog)) {
            return JdbcUtils.createObjectListResultSet(meta);
        }
        throw new UnsupportedOperationException("Index info is not supported yet.");
    }

    @Override
    public boolean supportsResultSetType(int type) {
        return type == 1003;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return this.supportsResultSetType(type) && concurrency == 1007;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPtrn, String typeNamePtrn, int[] types) throws SQLException {
        this.ensureNotClosed();
        return JdbcUtils.createObjectListResultSet(Arrays.asList(JdbcDatabaseMetadata.columnMeta("TYPE_CAT", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TYPE_SCHEM", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TYPE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("CLASS_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("DATA_TYPE", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("REMARKS", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("BASE_TYPE", ColumnType.INT16)));
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPtrn, String typeNamePtrn) throws SQLException {
        this.ensureNotClosed();
        return JdbcUtils.createObjectListResultSet(Arrays.asList(JdbcDatabaseMetadata.columnMeta("TYPE_CAT", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TYPE_SCHEM", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TYPE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("SUPERTYPE_CAT", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("SUPERTYPE_SCHEM", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("SUPERTYPE_NAME", ColumnType.STRING)));
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPtrn, String tblNamePtrn) throws SQLException {
        this.ensureNotClosed();
        return JdbcUtils.createObjectListResultSet(Arrays.asList(JdbcDatabaseMetadata.columnMeta("TABLE_CAT", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TABLE_SCHEM", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TABLE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("SUPERTABLE_NAME", ColumnType.STRING)));
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPtrn, String typeNamePtrn, String attributeNamePtrn) throws SQLException {
        this.ensureNotClosed();
        return JdbcUtils.createObjectListResultSet(Arrays.asList(JdbcDatabaseMetadata.columnMeta("TYPE_CAT", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TYPE_SCHEM", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TYPE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("ATTR_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("DATA_TYPE", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("ATTR_TYPE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("ATTR_SIZE", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("DECIMAL_DIGITS", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("NUM_PREC_RADIX", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("NULLABLE", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("REMARKS", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("ATTR_DEF", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("SQL_DATA_TYPE", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("SQL_DATETIME_SUB", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("CHAR_OCTET_LENGTH", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("ORDINAL_POSITION", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("IS_NULLABLE", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("SCOPE_CATALOG", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("SCOPE_SCHEMA", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("SCOPE_TABLE", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("SOURCE_DATA_TYPE", ColumnType.INT16)));
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) {
        return holdability == 2;
    }

    @Override
    public int getResultSetHoldability() {
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() {
        return ProtocolVersion.LATEST_VER.major();
    }

    @Override
    public int getDatabaseMinorVersion() {
        return ProtocolVersion.LATEST_VER.minor();
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 0;
    }

    @Override
    public int getSQLStateType() {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() {
        return JdbcUtils.createObjectListResultSet(Arrays.asList(JdbcDatabaseMetadata.columnMeta("NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("MAX_LEN", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("DEFAULT_VALUE", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("DESCRIPTION", ColumnType.STRING)));
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPtrn, String functionNamePtrn) throws SQLException {
        this.ensureNotClosed();
        return JdbcUtils.createObjectListResultSet(Arrays.asList(JdbcDatabaseMetadata.columnMeta("FUNCTION_CAT", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("FUNCTION_SCHEM", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("FUNCTION_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("REMARKS", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("FUNCTION_TYPE", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("SPECIFIC_NAME", ColumnType.STRING)));
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPtrn, String functionNamePtrn, String colNamePtrn) throws SQLException {
        this.ensureNotClosed();
        return JdbcUtils.createObjectListResultSet(Arrays.asList(JdbcDatabaseMetadata.columnMeta("FUNCTION_CAT", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("FUNCTION_SCHEM", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("FUNCTION_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("COLUMN_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("COLUMN_TYPE", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("DATA_TYPE", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("TYPE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("PRECISION", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("LENGTH", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("SCALE", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("RADIX", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("NULLABLE", ColumnType.INT16), JdbcDatabaseMetadata.columnMeta("REMARKS", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("CHAR_OCTET_LENGTH", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("ORDINAL_POSITION", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("IS_NULLABLE", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("SPECIFIC_NAME", ColumnType.STRING)));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Database meta data is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface != null && iface.isAssignableFrom(JdbcDatabaseMetadata.class);
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPtrn, String tblNamePtrn, String colNamePtrn) throws SQLException {
        this.ensureNotClosed();
        return JdbcUtils.createObjectListResultSet(Arrays.asList(JdbcDatabaseMetadata.columnMeta("TABLE_CAT", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TABLE_SCHEM", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("TABLE_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("COLUMN_NAME", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("DATA_TYPE", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("COLUMN_SIZE", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("DECIMAL_DIGITS", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("NUM_PREC_RADIX", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("COLUMN_USAGE", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("REMARKS", ColumnType.STRING), JdbcDatabaseMetadata.columnMeta("CHAR_OCTET_LENGTH", ColumnType.INT32), JdbcDatabaseMetadata.columnMeta("IS_NULLABLE", ColumnType.STRING)));
    }

    private static boolean isValidCatalog(String catalog) {
        return catalog == null || catalog.equalsIgnoreCase(CATALOG_NAME);
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return false;
    }

    private List<Object> tableRow(JdbcTableMeta tblMeta) {
        ArrayList<Object> row = new ArrayList<Object>(10);
        row.add(CATALOG_NAME);
        row.add(tblMeta.schemaName());
        row.add(tblMeta.tableName());
        row.add(tblMeta.tableType());
        row.add(null);
        row.add(null);
        row.add(null);
        row.add(null);
        row.add(null);
        row.add(null);
        return row;
    }

    public static List<Object> columnRow(JdbcColumnMeta colMeta, int pos) {
        ArrayList<Object> row = new ArrayList<Object>(24);
        row.add(CATALOG_NAME);
        row.add(colMeta.schemaName());
        row.add(colMeta.tableName());
        row.add(colMeta.columnLabel());
        row.add(colMeta.dataType());
        row.add(colMeta.dataTypeName());
        row.add(colMeta.precision() == -1 ? null : Integer.valueOf(colMeta.precision()));
        row.add(null);
        row.add(colMeta.scale() == -1 ? null : Integer.valueOf(colMeta.scale()));
        row.add(10);
        row.add(colMeta.isNullable() ? 1 : 0);
        row.add(null);
        row.add(colMeta.defaultValue());
        row.add(colMeta.dataType());
        row.add(null);
        row.add(Integer.MAX_VALUE);
        row.add(pos);
        row.add(colMeta.isNullable() ? "YES" : "NO");
        row.add(null);
        row.add(null);
        row.add(null);
        row.add(null);
        row.add("NO");
        row.add("NO");
        return row;
    }

    private static List<List<Object>> primaryKeyRows(JdbcPrimaryKeyMeta pkMeta) {
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>(pkMeta.fields().size());
        for (int i = 0; i < pkMeta.fields().size(); ++i) {
            ArrayList<Object> row = new ArrayList<Object>(6);
            row.add(CATALOG_NAME);
            row.add(pkMeta.schemaName());
            row.add(pkMeta.tableName());
            row.add(pkMeta.fields().get(i));
            row.add(i + 1);
            row.add(pkMeta.name());
            rows.add(row);
        }
        return rows;
    }

    private void ensureNotClosed() throws SQLException {
        if (this.connection.isClosed()) {
            throw new SQLException("Connection is closed.", "08003");
        }
    }

    private static ColumnMetadata columnMeta(String name, ColumnType type) {
        return new ColumnMetadataImpl(name, type, -1, -1, true, null);
    }
}

