/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.index;

import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogService;
import org.apache.ignite3.internal.hlc.HybridClock;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.index.message.IndexMessageGroup;
import org.apache.ignite3.internal.index.message.IndexMessagesFactory;
import org.apache.ignite3.internal.index.message.IsNodeFinishedRwTransactionsStartedBeforeRequest;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.manager.IgniteComponent;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.network.MessagingService;
import org.apache.ignite3.internal.network.NetworkMessage;
import org.apache.ignite3.internal.tx.ActiveLocalTxMinimumRequiredTimeProvider;
import org.apache.ignite3.internal.tx.LocalRwTxCounter;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.IgniteBusyLock;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class IndexNodeFinishedRwTransactionsChecker
implements LocalRwTxCounter,
ActiveLocalTxMinimumRequiredTimeProvider,
IgniteComponent {
    private static final IndexMessagesFactory FACTORY = new IndexMessagesFactory();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Map<HybridTimestamp, Integer> txCatalogVersionByBeginTxTs = new ConcurrentHashMap<HybridTimestamp, Integer>();
    private final NavigableMap<Integer, Long> txCountByCatalogVersion = new ConcurrentSkipListMap<Integer, Long>();
    private final CatalogService catalogService;
    private final MessagingService messagingService;
    private final HybridClock clock;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();

    public IndexNodeFinishedRwTransactionsChecker(CatalogService catalogService, MessagingService messagingService, HybridClock clock) {
        this.catalogService = catalogService;
        this.messagingService = messagingService;
        this.clock = clock;
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        return IgniteUtils.inBusyLockAsync(this.busyLock, () -> {
            this.messagingService.addMessageHandler(IndexMessageGroup.class, this::onReceiveIndexNetworkMessage);
            return CompletableFutures.nullCompletedFuture();
        });
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.busyLock.block();
        this.txCatalogVersionByBeginTxTs.clear();
        this.txCountByCatalogVersion.clear();
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public void incrementRwTxCount(HybridTimestamp beginTs) {
        assert (this.readWriteLock.getReadHoldCount() > 0) : "Expected to be called within inUpdateRwTxCountLock.";
        Integer txCatalogVersion = this.catalogService.activeCatalogVersion(beginTs.longValue());
        Integer previousTxCatalogVersion = this.txCatalogVersionByBeginTxTs.put(beginTs, txCatalogVersion);
        assert (previousTxCatalogVersion == null) : beginTs;
        this.txCountByCatalogVersion.compute(txCatalogVersion, (i, txCount) -> txCount == null ? 1L : txCount + 1L);
    }

    @Override
    public void decrementRwTxCount(HybridTimestamp beginTs) {
        assert (this.readWriteLock.getReadHoldCount() > 0) : "Expected to be called within inUpdateRwTxCountLock.";
        Integer txCatalogVersion = this.txCatalogVersionByBeginTxTs.remove(beginTs);
        if (txCatalogVersion == null) {
            return;
        }
        this.txCountByCatalogVersion.compute(txCatalogVersion, (i, txCount) -> {
            assert (txCount != null) : txCatalogVersion;
            return txCount == 1L ? null : Long.valueOf(txCount - 1L);
        });
    }

    @Override
    public <T> T inUpdateRwTxCountLock(Supplier<T> supplier) {
        return (T)IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            this.readWriteLock.readLock().lock();
            try {
                Object t = supplier.get();
                return t;
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
        });
    }

    @Override
    public void clear() {
        this.readWriteLock.writeLock().lock();
        try {
            this.txCatalogVersionByBeginTxTs.clear();
            this.txCountByCatalogVersion.clear();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long minimumRequiredTime() {
        int minRequiredVer;
        this.readWriteLock.writeLock().lock();
        try {
            Map.Entry<Integer, Long> entry = this.txCountByCatalogVersion.firstEntry();
            if (entry == null) {
                long l = this.clock.now().longValue();
                return l;
            }
            minRequiredVer = entry.getKey();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        Catalog catalog = this.catalogService.catalog(minRequiredVer);
        assert (catalog != null) : "minRequiredVer=" + minRequiredVer;
        return catalog.time();
    }

    private void onReceiveIndexNetworkMessage(NetworkMessage message, InternalClusterNode sender, @Nullable Long correlationId) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            if (!(message instanceof IsNodeFinishedRwTransactionsStartedBeforeRequest)) {
                return;
            }
            assert (correlationId != null) : sender;
            int targetCatalogVersion = ((IsNodeFinishedRwTransactionsStartedBeforeRequest)message).targetCatalogVersion();
            boolean finished = this.isNodeFinishedRwTransactionsStartedBefore(targetCatalogVersion);
            this.messagingService.respond(sender, (NetworkMessage)FACTORY.isNodeFinishedRwTransactionsStartedBeforeResponse().finished(finished).build(), (long)correlationId);
        });
    }

    private boolean isNodeFinishedRwTransactionsStartedBefore(int catalogVersion) {
        this.readWriteLock.writeLock().lock();
        try {
            if (catalogVersion > this.catalogService.activeCatalogVersion(this.clock.nowLong())) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.txCountByCatalogVersion.headMap(catalogVersion).isEmpty();
            return bl;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }
}

