/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.index;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.apache.ignite3.internal.close.ManuallyCloseable;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.index.FinalTransactionStateResolver;
import org.apache.ignite3.internal.index.IndexBuildCompletionListener;
import org.apache.ignite3.internal.index.IndexBuildTask;
import org.apache.ignite3.internal.index.IndexBuildTaskId;
import org.apache.ignite3.internal.index.IndexBuilderMetricSource;
import org.apache.ignite3.internal.metrics.MetricManager;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.partition.replicator.TableTxRwOperationTracker;
import org.apache.ignite3.internal.replicator.ReplicaService;
import org.apache.ignite3.internal.storage.MvPartitionStorage;
import org.apache.ignite3.internal.storage.index.IndexStorage;
import org.apache.ignite3.internal.table.distributed.index.IndexMeta;
import org.apache.ignite3.internal.table.distributed.index.IndexMetaStorage;
import org.apache.ignite3.internal.table.distributed.index.MetaIndexStatus;
import org.apache.ignite3.internal.table.distributed.index.MetaIndexStatusChange;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.internal.util.PendingComparableValuesTracker;

class IndexBuilder
implements ManuallyCloseable {
    static final int BATCH_SIZE = 100;
    private final Executor executor;
    private final ReplicaService replicaService;
    private final FailureProcessor failureProcessor;
    private final FinalTransactionStateResolver finalTransactionStateResolver;
    private final IndexMetaStorage indexMetaStorage;
    private final Map<IndexBuildTaskId, IndexBuildTask> indexBuildTaskById = new ConcurrentHashMap<IndexBuildTaskId, IndexBuildTask>();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean closeGuard = new AtomicBoolean();
    private final List<IndexBuildCompletionListener> buildCompletionListeners = new CopyOnWriteArrayList<IndexBuildCompletionListener>();
    private final IndexBuilderMetricSource indexBuilderMetricSource = new IndexBuilderMetricSource();

    IndexBuilder(Executor executor, ReplicaService replicaService, FailureProcessor failureProcessor, FinalTransactionStateResolver finalTransactionStateResolver, IndexMetaStorage indexMetaStorage, MetricManager metricManager) {
        metricManager.registerSource(this.indexBuilderMetricSource);
        metricManager.enable(this.indexBuilderMetricSource);
        this.executor = executor;
        this.replicaService = replicaService;
        this.failureProcessor = failureProcessor;
        this.finalTransactionStateResolver = finalTransactionStateResolver;
        this.indexMetaStorage = indexMetaStorage;
    }

    public void scheduleBuildIndex(int zoneId, int tableId, int partitionId, int indexId, IndexStorage indexStorage, MvPartitionStorage partitionStorage, TableTxRwOperationTracker partitionTxRwOperationTracker, PendingComparableValuesTracker<HybridTimestamp, Void> partitionSafeTime, InternalClusterNode node, long enlistmentConsistencyToken, HybridTimestamp initialOperationTimestamp) {
        IgniteUtils.inBusyLockSafe(this.busyLock, () -> {
            if (indexStorage.getNextRowIdToBuild() == null) {
                for (IndexBuildCompletionListener listener : this.buildCompletionListeners) {
                    listener.onBuildCompletion(indexId, tableId, partitionId);
                }
                return;
            }
            IndexBuildTaskId taskId = new IndexBuildTaskId(zoneId, tableId, partitionId, indexId);
            IndexBuildTask newTask = new IndexBuildTask(taskId, this.indexCreationInfo(indexId), this.indexBuildingStateActivationTimestamp(indexId), indexStorage, partitionStorage, this.replicaService, partitionTxRwOperationTracker, partitionSafeTime, this.failureProcessor, this.finalTransactionStateResolver, this.executor, this.busyLock, 100, node, this.buildCompletionListeners, enlistmentConsistencyToken, false, initialOperationTimestamp, this.indexBuilderMetricSource);
            this.putAndStartTaskIfAbsent(taskId, newTask);
        });
    }

    public void scheduleBuildIndexAfterDisasterRecovery(int zoneId, int tableId, int partitionId, int indexId, IndexStorage indexStorage, MvPartitionStorage partitionStorage, TableTxRwOperationTracker partitionTxRwOperationTracker, PendingComparableValuesTracker<HybridTimestamp, Void> partitionSafeTime, InternalClusterNode node, long enlistmentConsistencyToken, HybridTimestamp initialOperationTimestamp) {
        IgniteUtils.inBusyLockSafe(this.busyLock, () -> {
            if (indexStorage.getNextRowIdToBuild() == null) {
                return;
            }
            IndexBuildTaskId taskId = new IndexBuildTaskId(zoneId, tableId, partitionId, indexId);
            IndexBuildTask newTask = new IndexBuildTask(taskId, this.indexCreationInfo(indexId), this.indexBuildingStateActivationTimestamp(indexId), indexStorage, partitionStorage, this.replicaService, partitionTxRwOperationTracker, partitionSafeTime, this.failureProcessor, this.finalTransactionStateResolver, this.executor, this.busyLock, 100, node, this.buildCompletionListeners, enlistmentConsistencyToken, true, initialOperationTimestamp, this.indexBuilderMetricSource);
            this.putAndStartTaskIfAbsent(taskId, newTask);
        });
    }

    private MetaIndexStatusChange indexCreationInfo(int indexId) {
        return this.requiredIndexMeta(indexId).statusChange(MetaIndexStatus.REGISTERED);
    }

    private IndexMeta requiredIndexMeta(int indexId) {
        IndexMeta indexMeta = this.indexMetaStorage.indexMeta(indexId);
        assert (indexMeta != null) : "Index meta must be present for indexId=" + indexId;
        return indexMeta;
    }

    private HybridTimestamp indexBuildingStateActivationTimestamp(int indexId) {
        MetaIndexStatusChange statusChange = this.requiredIndexMeta(indexId).statusChange(MetaIndexStatus.BUILDING);
        return HybridTimestamp.hybridTimestamp(statusChange.activationTimestamp());
    }

    public void stopBuildingZoneIndexes(int zoneId, int partitionId) {
        this.stopBuildingIndexes(taskId -> zoneId == taskId.getZoneId() && partitionId == taskId.getPartitionId());
    }

    public void stopBuildingIndexes(int indexId) {
        this.stopBuildingIndexes(taskId -> indexId == taskId.getIndexId());
    }

    private void stopBuildingIndexes(Predicate<IndexBuildTaskId> stopBuildIndexPredicate) {
        Iterator<Map.Entry<IndexBuildTaskId, IndexBuildTask>> it = this.indexBuildTaskById.entrySet().iterator();
        while (it.hasNext()) {
            IgniteUtils.inBusyLockSafe(this.busyLock, () -> {
                Map.Entry entry = (Map.Entry)it.next();
                if (stopBuildIndexPredicate.test((IndexBuildTaskId)entry.getKey())) {
                    it.remove();
                    ((IndexBuildTask)entry.getValue()).stop();
                }
            });
        }
    }

    @Override
    public void close() {
        if (!this.closeGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
    }

    public void listen(IndexBuildCompletionListener listener) {
        this.buildCompletionListeners.add(listener);
    }

    public void stopListen(IndexBuildCompletionListener listener) {
        this.buildCompletionListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putAndStartTaskIfAbsent(IndexBuildTaskId taskId, IndexBuildTask task) {
        IndexBuildTask previousTask = this.indexBuildTaskById.putIfAbsent(taskId, task);
        if (previousTask != null) {
            return;
        }
        try {
            task.start();
        }
        finally {
            task.getTaskFuture().whenComplete((unused, throwable) -> this.indexBuildTaskById.remove(taskId));
        }
    }
}

