/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.failure.handlers;

import org.apache.ignite3.internal.failure.FailureContext;
import org.apache.ignite3.internal.failure.NodeStopper;
import org.apache.ignite3.internal.failure.handlers.AbstractFailureHandler;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.thread.IgniteThread;
import org.apache.ignite3.internal.thread.IgniteThreadFactory;
import org.apache.ignite3.internal.thread.ThreadOperation;
import org.apache.ignite3.internal.tostring.IgniteToStringExclude;
import org.apache.ignite3.internal.tostring.S;

public class StopNodeFailureHandler
extends AbstractFailureHandler {
    private static final IgniteLogger LOG = Loggers.forClass(StopNodeFailureHandler.class);
    private final String nodeName;
    @IgniteToStringExclude
    private final NodeStopper nodeStopper;

    public StopNodeFailureHandler(String nodeName, NodeStopper nodeStopper) {
        this.nodeName = nodeName;
        this.nodeStopper = nodeStopper;
    }

    @Override
    protected boolean handle(FailureContext failureCtx) {
        IgniteThreadFactory threadFactory = IgniteThreadFactory.create(this.nodeName, "node-stopper", true, LOG, ThreadOperation.values());
        IgniteThread nodeStopperThread = threadFactory.newThread(this.nodeStopper::stopNode);
        nodeStopperThread.start();
        return true;
    }

    @Override
    public String toString() {
        return S.toString(StopNodeFailureHandler.class, this, super.toString());
    }
}

