/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.eventlog.impl;

import java.util.HashSet;
import java.util.Set;
import org.apache.ignite3.internal.eventlog.api.Event;
import org.apache.ignite3.internal.eventlog.api.EventChannel;
import org.apache.ignite3.internal.eventlog.api.Sink;
import org.apache.ignite3.internal.eventlog.impl.SinkRegistry;

class EventChannelImpl
implements EventChannel {
    private final SinkRegistry sinkRegistry;
    private final Set<String> types;
    private final String channelName;

    EventChannelImpl(String channelName, Set<String> types, SinkRegistry sinkRegistry) {
        this.types = new HashSet<String>(types);
        this.channelName = channelName;
        this.sinkRegistry = sinkRegistry;
    }

    @Override
    public Set<String> types() {
        return this.types;
    }

    @Override
    public void log(Event event) {
        Set<Sink<?>> sinks = this.sinkRegistry.findAllByChannel(this.channelName);
        if (sinks == null) {
            return;
        }
        sinks.forEach(s -> s.write(event));
    }
}

