/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.deployunit.loader;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite3.deployment.DeploymentUnit;
import org.apache.ignite3.deployment.version.Version;
import org.apache.ignite3.internal.deployunit.DeploymentStatus;
import org.apache.ignite3.internal.deployunit.DeploymentUnitAccessor;
import org.apache.ignite3.internal.deployunit.DisposableDeploymentUnit;
import org.apache.ignite3.internal.deployunit.IgniteDeployment;
import org.apache.ignite3.internal.deployunit.exception.DeploymentUnitNotFoundException;
import org.apache.ignite3.internal.deployunit.exception.DeploymentUnitUnavailableException;
import org.apache.ignite3.internal.deployunit.loader.ClassLoaderExceptionsMapper;
import org.apache.ignite3.internal.deployunit.loader.UnitsClassLoader;
import org.apache.ignite3.internal.deployunit.loader.UnitsClassLoaderContext;
import org.apache.ignite3.internal.deployunit.loader.UnitsClassLoaderFactory;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.RefCountedObjectPool;
import org.apache.ignite3.lang.ErrorGroups;
import org.gridgain.internal.security.context.GridGainSecurity;

public class UnitsContextManager {
    private static final IgniteLogger LOG = Loggers.forClass(UnitsContextManager.class);
    private final RefCountedObjectPool<List<DeploymentUnit>, UnitsClassLoader> classLoaderPool = new RefCountedObjectPool();
    private final IgniteDeployment deployment;
    private final DeploymentUnitAccessor deploymentUnitAccessor;
    private final UnitsClassLoaderFactory classLoaderFactory;

    public UnitsContextManager(IgniteDeployment deployment, DeploymentUnitAccessor deploymentUnitAccessor, UnitsClassLoaderFactory classLoaderFactory) {
        this.deployment = deployment;
        this.deploymentUnitAccessor = deploymentUnitAccessor;
        this.classLoaderFactory = classLoaderFactory;
    }

    public CompletableFuture<UnitsClassLoaderContext> acquireClassLoader(List<DeploymentUnit> units) {
        return this.acquireClassLoader(units, units.stream().map(DeploymentUnit::toString).collect(Collectors.joining(", ")));
    }

    public CompletableFuture<UnitsClassLoaderContext> acquireClassLoader(List<DeploymentUnit> units, String id) {
        CompletionStage loaderFut = ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.normalizeVersions(units).thenCompose(normalizedUnits -> this.checkUnitStatuses((List<DeploymentUnit>)normalizedUnits).thenApply(v -> normalizedUnits))).thenCompose(normalizedUnits -> this.onDemandDeploy((List<DeploymentUnit>)normalizedUnits).thenApply(v -> normalizedUnits))).thenApply(normalizedUnits -> this.classLoaderPool.acquire((List<DeploymentUnit>)normalizedUnits, this::createClassLoader))).thenApply(loader -> new UnitsClassLoaderContext((UnitsClassLoader)loader, this::releaseClassLoader));
        CompletionStage contextFut = ClassLoaderExceptionsMapper.mapClassLoaderExceptions((CompletableFuture<UnitsClassLoaderContext>)loaderFut, id).whenComplete((context, error) -> {
            if (error != null) {
                LOG.error("Failed to acquire class loader for units: " + units, (Throwable)error);
            } else {
                LOG.debug("Acquired class loader for units: " + units, new Object[0]);
            }
        });
        ((CompletableFuture)contextFut).exceptionally(arg_0 -> UnitsContextManager.lambda$acquireClassLoader$7((CompletableFuture)loaderFut, arg_0));
        return contextFut;
    }

    private UnitsClassLoader createClassLoader(List<DeploymentUnit> units) {
        List<DisposableDeploymentUnit> disposableDeploymentUnits = units.stream().map(this.deploymentUnitAccessor::acquire).collect(Collectors.toList());
        return this.classLoaderFactory.createClassLoader(disposableDeploymentUnits);
    }

    private void releaseClassLoader(UnitsClassLoaderContext jobContext) {
        List units = jobContext.classLoader().units().stream().map(DisposableDeploymentUnit::unit).collect(Collectors.toList());
        if (this.classLoaderPool.release(units)) {
            jobContext.classLoader().close();
        }
    }

    private CompletableFuture<Void> checkUnitStatuses(List<DeploymentUnit> units) {
        return UnitsContextManager.mapList(units, this::checkUnitStatus, CompletableFuture::allOf);
    }

    private CompletableFuture<Void> checkUnitStatus(DeploymentUnit unit) {
        return GridGainSecurity.bypass(() -> this.deployment.clusterStatusAsync(unit.name(), unit.version())).thenCompose(clusterStatus -> {
            if (clusterStatus == DeploymentStatus.DEPLOYED) {
                return CompletableFutures.nullCompletedFuture();
            }
            if (clusterStatus == null) {
                return CompletableFuture.failedFuture(new DeploymentUnitNotFoundException(unit.name(), unit.version()));
            }
            return GridGainSecurity.bypass(() -> this.deployment.nodeStatusAsync(unit.name(), unit.version())).thenCompose(nodeStatus -> CompletableFuture.failedFuture(new DeploymentUnitUnavailableException(unit.name(), unit.version(), (DeploymentStatus)((Object)clusterStatus), (DeploymentStatus)((Object)((Object)nodeStatus)))));
        });
    }

    private CompletableFuture<List<DeploymentUnit>> normalizeVersions(List<DeploymentUnit> units) {
        return UnitsContextManager.mapList(units, this::normalizeVersion, CompletableFutures::allOfToList);
    }

    private CompletableFuture<Void> onDemandDeploy(List<DeploymentUnit> units) {
        return UnitsContextManager.mapList(units, unit -> this.deployment.onDemandDeploy(unit.name(), unit.version()).thenAccept(result -> {
            if (!result.booleanValue()) {
                throw new IgniteInternalException(ErrorGroups.Compute.CLASS_LOADER_ERR, "Failed to deploy on demand unit: " + unit.render());
            }
        }), CompletableFuture::allOf);
    }

    private CompletableFuture<DeploymentUnit> normalizeVersion(DeploymentUnit unit) {
        if (unit.version() == Version.LATEST) {
            return GridGainSecurity.bypass(() -> this.deployment.detectLatestDeployedVersion(unit.name())).thenApply(version -> new DeploymentUnit(unit.name(), (Version)version));
        }
        return CompletableFuture.completedFuture(unit);
    }

    private static <I, O, R> CompletableFuture<R> mapList(List<I> list, Function<I, CompletableFuture<O>> mapper, Function<CompletableFuture<O>[], CompletableFuture<R>> collector) {
        CompletableFuture[] futures = new CompletableFuture[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            futures[i] = mapper.apply(list.get(i));
        }
        return collector.apply(futures);
    }

    private static /* synthetic */ UnitsClassLoaderContext lambda$acquireClassLoader$7(CompletableFuture loaderFut, Throwable e) {
        loaderFut.thenAccept(UnitsClassLoaderContext::close);
        return null;
    }
}

