/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.deployunit;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.deployunit.DeploymentUnit;
import org.apache.ignite3.internal.deployunit.DeploymentUnitProcessor;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;

public class CachedDeploymentUnit
implements DeploymentUnit {
    private static final IgniteLogger LOG = Loggers.forClass(CachedDeploymentUnit.class);
    private final CompletableFuture<DeploymentUnit> future;

    public CachedDeploymentUnit(CompletableFuture<DeploymentUnit> future) {
        this.future = future;
    }

    @Override
    public <T, R> CompletableFuture<R> process(DeploymentUnitProcessor<T, R> processor, T arg) {
        return this.future.thenCompose(unit -> unit.process(processor, arg));
    }

    @Override
    public void close() throws Exception {
        this.future.whenComplete((unit, throwable) -> {
            if (throwable != null) {
                LOG.info("Future to access cached unit is failed.", (Throwable)throwable);
            } else {
                try {
                    unit.close();
                }
                catch (Exception e) {
                    LOG.warn("Failed to close deployment unit: {}", e, unit);
                }
            }
        });
    }
}

