/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.continuousquery;

import java.io.Serializable;
import java.util.List;
import org.apache.ignite3.internal.continuousquery.ContinuousQueryScanResultStatus;
import org.apache.ignite3.internal.continuousquery.RowUpdateInfo;
import org.jetbrains.annotations.Nullable;

public class ContinuousQueryScanResult<RowT>
implements Serializable {
    private static final long serialVersionUID = 3783750262350629473L;
    private final long safeTime;
    private final List<? extends RowUpdateInfo<RowT>> rows;
    private final int schemaVersion;
    private final long requestId;
    @Nullable
    private final Throwable error;
    private final ContinuousQueryScanResultStatus status;

    public ContinuousQueryScanResult(long safeTime, List<? extends RowUpdateInfo<RowT>> rows, int schemaVersion, long requestId, ContinuousQueryScanResultStatus status) {
        this.safeTime = safeTime;
        this.rows = rows;
        this.schemaVersion = schemaVersion;
        this.requestId = requestId;
        this.error = null;
        this.status = status;
    }

    public ContinuousQueryScanResult(long requestId, Throwable error) {
        this.safeTime = 0L;
        this.rows = List.of();
        this.schemaVersion = 0;
        this.requestId = requestId;
        this.error = error;
        this.status = ContinuousQueryScanResultStatus.ERROR;
    }

    public long safeTime() {
        return this.safeTime;
    }

    public List<? extends RowUpdateInfo<RowT>> rows() {
        return this.rows;
    }

    public int schemaVersion() {
        return this.schemaVersion;
    }

    public long requestId() {
        return this.requestId;
    }

    @Nullable
    public Throwable error() {
        return this.error;
    }

    public ContinuousQueryScanResultStatus status() {
        return this.status;
    }
}

