/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.streamer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.compute.ComputeJob;
import org.apache.ignite3.compute.JobExecutionContext;
import org.apache.ignite3.internal.client.proto.StreamerReceiverSerializer;
import org.apache.ignite3.internal.compute.ComputeUtils;
import org.apache.ignite3.internal.compute.JobExecutionContextImpl;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.table.DataStreamerReceiver;
import org.apache.ignite3.table.DataStreamerReceiverContext;
import org.jetbrains.annotations.Nullable;

public class StreamerReceiverJob
implements ComputeJob<byte[], byte[]> {
    @Override
    @Nullable
    public CompletableFuture<byte[]> executeAsync(JobExecutionContext context, byte @Nullable [] payload) {
        assert (payload != null) : "Streamer receiver job argument is null";
        ByteBuffer buf = ByteBuffer.wrap(payload).order(ByteOrder.LITTLE_ENDIAN);
        int payloadElementCount = buf.getInt();
        StreamerReceiverSerializer.SteamerReceiverInfo receiverInfo = StreamerReceiverSerializer.deserializeReceiverInfo(buf.slice().order(ByteOrder.LITTLE_ENDIAN), payloadElementCount, receiverClassName -> {
            ClassLoader classLoader = ((JobExecutionContextImpl)context).classLoader().classLoader();
            Class receiverClass = ComputeUtils.receiverClass(classLoader, receiverClassName);
            return ComputeUtils.instantiateReceiver(receiverClass);
        });
        DataStreamerReceiverContext receiverContext = context::ignite;
        DataStreamerReceiver<Object, Object, Object> receiver = receiverInfo.receiver();
        CompletableFuture<List<Object>> receiverRes = receiver.receive(receiverInfo.items(), receiverContext, receiverInfo.arg());
        if (receiverRes == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        return receiverRes.thenApply(r -> StreamerReceiverSerializer.serializeReceiverJobResults(r, receiver.resultMarshaller()));
    }
}

