/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite3.internal.compute.message.JobChangePriorityResponse;
import org.apache.ignite3.internal.compute.message.JobChangePriorityResponseBuilder;
import org.apache.ignite3.internal.compute.message.JobChangePriorityResponseSerializer;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class JobChangePriorityResponseImpl
implements JobChangePriorityResponse,
Cloneable {
    public static final short GROUP_TYPE = 6;
    public static final short TYPE = 10;
    @IgniteToStringInclude
    private final Boolean result;
    @IgniteToStringInclude
    private Throwable throwable;
    private byte[] throwableByteArray;

    private JobChangePriorityResponseImpl(Boolean result, Throwable throwable, byte[] throwableByteArray) {
        this.result = result;
        this.throwable = throwable;
        this.throwableByteArray = throwableByteArray;
    }

    @Override
    public Boolean result() {
        return this.result;
    }

    byte[] throwableByteArray() {
        return this.throwableByteArray;
    }

    @Override
    public Throwable throwable() {
        return this.throwable;
    }

    public MessageSerializer serializer() {
        return JobChangePriorityResponseSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 6;
    }

    public String toString() {
        return S.toString(JobChangePriorityResponseImpl.class, this);
    }

    @Override
    public short messageType() {
        return 10;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        JobChangePriorityResponseImpl otherMessage = (JobChangePriorityResponseImpl)other;
        return Objects.equals(this.result, otherMessage.result) && Objects.equals(this.throwable, otherMessage.throwable);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.result, this.throwable);
        return result;
    }

    @Override
    public JobChangePriorityResponseImpl clone() {
        try {
            return (JobChangePriorityResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static JobChangePriorityResponseBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject throwableByteArraymo = marshaller.marshal(this.throwable);
        usedDescriptors.addAll((IntCollection)throwableByteArraymo.usedDescriptorIds());
        this.throwableByteArray = throwableByteArraymo.bytes();
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.throwable = (Throwable)marshaller.unmarshal(this.throwableByteArray, descriptorsObj);
        this.throwableByteArray = null;
    }

    private static class Builder
    implements JobChangePriorityResponseBuilder {
        private Boolean result;
        private Throwable throwable;
        private byte[] throwableByteArray;

        private Builder() {
        }

        @Override
        public JobChangePriorityResponseBuilder result(Boolean result) {
            this.result = result;
            return this;
        }

        @Override
        public JobChangePriorityResponseBuilder throwable(Throwable throwable) {
            this.throwable = throwable;
            return this;
        }

        @Override
        public JobChangePriorityResponseBuilder throwableByteArray(byte[] throwableByteArray) {
            this.throwableByteArray = throwableByteArray;
            return this;
        }

        @Override
        public Boolean result() {
            return this.result;
        }

        @Override
        public Throwable throwable() {
            return this.throwable;
        }

        @Override
        public byte[] throwableByteArray() {
            return this.throwableByteArray;
        }

        @Override
        public JobChangePriorityResponse build() {
            return new JobChangePriorityResponseImpl(this.result, this.throwable, this.throwableByteArray);
        }

        @Override
        public JobChangePriorityResponse buildDeserialized() {
            return new JobChangePriorityResponseImpl(this.result, this.throwable, this.throwableByteArray);
        }
    }
}

