/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.executor.wasm;

import java.util.Objects;
import org.apache.ignite3.deployment.version.Version;

class WasmModuleCacheKey {
    private final String moduleName;
    private final String deploymentUnitName;
    private final Version deploymentUnitVersion;
    private final int index;

    WasmModuleCacheKey(String moduleName, String deploymentUnitName, Version deploymentUnitVersion, int index) {
        this.moduleName = moduleName;
        this.deploymentUnitName = deploymentUnitName;
        this.deploymentUnitVersion = deploymentUnitVersion;
        this.index = index;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WasmModuleCacheKey that = (WasmModuleCacheKey)o;
        return this.index == that.index && Objects.equals(this.moduleName, that.moduleName) && Objects.equals(this.deploymentUnitName, that.deploymentUnitName) && Objects.equals(this.deploymentUnitVersion, that.deploymentUnitVersion);
    }

    WasmModuleCacheKey nextIndex() {
        return new WasmModuleCacheKey(this.moduleName, this.deploymentUnitName, this.deploymentUnitVersion, this.index + 1);
    }

    public int hashCode() {
        return Objects.hash(this.moduleName, this.deploymentUnitName, this.deploymentUnitVersion, this.index);
    }
}

