/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.executor;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.ignite3.cache.CacheStoreFactory;
import org.apache.ignite3.internal.compute.executor.SecuredKeyValueView;
import org.apache.ignite3.internal.compute.executor.SecuredRecordView;
import org.apache.ignite3.internal.continuousquery.ContinuousQueryRequest;
import org.apache.ignite3.internal.continuousquery.ContinuousQueryScanResultWithSchema;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.ColumnsExtractor;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.schema.SchemaRegistry;
import org.apache.ignite3.internal.storage.index.StorageHashIndexDescriptor;
import org.apache.ignite3.internal.storage.index.StorageSortedIndexDescriptor;
import org.apache.ignite3.internal.table.InternalTable;
import org.apache.ignite3.internal.table.TableViewInternal;
import org.apache.ignite3.internal.table.distributed.IndexLocker;
import org.apache.ignite3.internal.table.distributed.PartitionSet;
import org.apache.ignite3.internal.table.distributed.TableIndexStoragesSupplier;
import org.apache.ignite3.internal.table.distributed.TableStatsStalenessConfiguration;
import org.apache.ignite3.internal.table.metrics.TableMetricSource;
import org.apache.ignite3.table.KeyValueView;
import org.apache.ignite3.table.QualifiedName;
import org.apache.ignite3.table.RecordView;
import org.apache.ignite3.table.TableViewOptions;
import org.apache.ignite3.table.Tuple;
import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.table.partition.PartitionDistribution;
import org.apache.ignite3.table.partition.PartitionManager;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rbac.privileges.Action;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.rbac.privileges.Selector;
import org.gridgain.internal.security.context.SecurityContext;
import org.jetbrains.annotations.Nullable;

class SecuredTableViewInternal
implements TableViewInternal {
    private final TableViewInternal delegate;
    private final Authorizer authorizer;
    private final SecurityContext context;

    SecuredTableViewInternal(TableViewInternal delegate, Authorizer authorizer, SecurityContext context) {
        this.delegate = delegate;
        this.authorizer = authorizer;
        this.context = context;
    }

    @Override
    public int partitionId(Tuple key) {
        return this.delegate.partitionId(key);
    }

    @Override
    public <K> int partitionId(K key, Mapper<K> keyMapper) {
        return this.delegate.partitionId(key, keyMapper);
    }

    @Override
    public TableIndexStoragesSupplier indexStorageAdapters(int partitionId) {
        return this.delegate.indexStorageAdapters(partitionId);
    }

    @Override
    public Supplier<Map<Integer, IndexLocker>> indexesLockers(int partId) {
        return this.delegate.indexesLockers(partId);
    }

    @Override
    public void registerHashIndex(StorageHashIndexDescriptor indexDescriptor, boolean unique, ColumnsExtractor searchRowResolver, PartitionSet partitions) {
        this.delegate.registerHashIndex(indexDescriptor, unique, searchRowResolver, partitions);
    }

    @Override
    public void registerSortedIndex(StorageSortedIndexDescriptor indexDescriptor, boolean unique, ColumnsExtractor searchRowResolver, PartitionSet partitions) {
        this.delegate.registerSortedIndex(indexDescriptor, unique, searchRowResolver, partitions);
    }

    @Override
    public void unregisterIndex(int indexId) {
        this.delegate.unregisterIndex(indexId);
    }

    @Override
    public TableMetricSource metrics() {
        return this.delegate.metrics();
    }

    @Override
    public int tableId() {
        return this.delegate.tableId();
    }

    @Override
    public int zoneId() {
        return this.delegate.zoneId();
    }

    @Override
    public int pkId() {
        return this.delegate.pkId();
    }

    @Override
    public InternalTable internalTable() {
        return this.delegate.internalTable();
    }

    @Override
    public SchemaRegistry schemaView() {
        return this.delegate.schemaView();
    }

    @Override
    public void schemaView(SchemaRegistry schemaReg) {
        this.delegate.schemaView(schemaReg);
    }

    @Override
    public String name() {
        return this.delegate.name();
    }

    @Override
    public QualifiedName qualifiedName() {
        return this.delegate.qualifiedName();
    }

    @Override
    public PartitionManager partitionManager() {
        return this.delegate.partitionManager();
    }

    @Override
    public PartitionDistribution partitionDistribution() {
        return this.delegate.partitionDistribution();
    }

    @Override
    public <R> RecordView<R> recordView(Mapper<R> recMapper) {
        return new SecuredRecordView<R>(this.delegate.recordView(recMapper), this.authorizer, this.context, this.delegate.qualifiedName());
    }

    @Override
    public RecordView<Tuple> recordView() {
        return new SecuredRecordView<Tuple>(this.delegate.recordView(), this.authorizer, this.context, this.delegate.qualifiedName());
    }

    @Override
    public <R> RecordView<R> recordView(Mapper<R> recMapper, TableViewOptions tableViewOptions) {
        return new SecuredRecordView<R>(this.delegate.recordView(recMapper, tableViewOptions), this.authorizer, this.context, this.delegate.qualifiedName());
    }

    @Override
    public RecordView<Tuple> recordView(TableViewOptions tableViewOptions) {
        return new SecuredRecordView<Tuple>(this.delegate.recordView(tableViewOptions), this.authorizer, this.context, this.delegate.qualifiedName());
    }

    @Override
    public <K, V> KeyValueView<K, V> keyValueView(Mapper<K> keyMapper, Mapper<V> valMapper) {
        return new SecuredKeyValueView<K, V>(this.delegate.keyValueView(keyMapper, valMapper), this.authorizer, this.context, this.delegate.qualifiedName());
    }

    @Override
    public KeyValueView<Tuple, Tuple> keyValueView() {
        return new SecuredKeyValueView<Tuple, Tuple>(this.delegate.keyValueView(), this.authorizer, this.context, this.delegate.qualifiedName());
    }

    @Override
    public <K, V> KeyValueView<K, V> keyValueView(Mapper<K> keyMapper, Mapper<V> valMapper, TableViewOptions tableViewOptions) {
        return new SecuredKeyValueView<K, V>(this.delegate.keyValueView(keyMapper, valMapper, tableViewOptions), this.authorizer, this.context, this.delegate.qualifiedName());
    }

    @Override
    public KeyValueView<Tuple, Tuple> keyValueView(TableViewOptions tableViewOptions) {
        return new SecuredKeyValueView<Tuple, Tuple>(this.delegate.keyValueView(tableViewOptions), this.authorizer, this.context, this.delegate.qualifiedName());
    }

    @Override
    public <K, V> KeyValueView<K, V> keyValueView(CacheStoreFactory fac, Mapper<K> keyMapper, Mapper<V> valMapper) {
        return new SecuredKeyValueView<K, V>(this.delegate.keyValueView(fac, keyMapper, valMapper), this.authorizer, this.context, this.delegate.qualifiedName());
    }

    @Override
    public KeyValueView<Tuple, Tuple> keyValueView(CacheStoreFactory fac) {
        return new SecuredKeyValueView<Tuple, Tuple>(this.delegate.keyValueView(fac), this.authorizer, this.context, this.delegate.qualifiedName());
    }

    @Override
    public boolean cache() {
        return this.delegate.cache();
    }

    @Override
    public TableStatsStalenessConfiguration stalenessConfiguration() {
        return this.delegate.stalenessConfiguration();
    }

    @Override
    public void updateStalenessConfiguration(@Nullable Double staleRowsFraction, @Nullable Long minStaleRowsCount) {
        this.delegate.updateStalenessConfiguration(staleRowsFraction, minStaleRowsCount);
    }

    @Override
    public CompletableFuture<ContinuousQueryScanResultWithSchema<BinaryRow, SchemaDescriptor>> sendContinuousQueryRequest(ContinuousQueryRequest req) {
        Privilege privilege = Privilege.builder().action(Action.SELECT_FROM_TABLE).selector(Selector.table(this.delegate.qualifiedName().schemaName(), this.delegate.qualifiedName().objectName())).build();
        return this.authorizer.authorizeThenCompose(this.context, privilege, () -> this.delegate.sendContinuousQueryRequest(req));
    }
}

