/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.executor;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.Ignite;
import org.apache.ignite3.cache.manager.IgniteCaches;
import org.apache.ignite3.catalog.IgniteCatalog;
import org.apache.ignite3.compute.IgniteCompute;
import org.apache.ignite3.internal.catalog.sql.IgniteCatalogSqlImpl;
import org.apache.ignite3.internal.compute.SecuredIgniteCompute;
import org.apache.ignite3.internal.compute.executor.SecuredIgniteTables;
import org.apache.ignite3.internal.sql.api.SecuredIgniteSql;
import org.apache.ignite3.internal.wrapper.Wrapper;
import org.apache.ignite3.internal.wrapper.Wrappers;
import org.apache.ignite3.network.ClusterNode;
import org.apache.ignite3.network.IgniteCluster;
import org.apache.ignite3.sql.IgniteSql;
import org.apache.ignite3.table.IgniteTables;
import org.apache.ignite3.tx.IgniteTransactions;
import org.gridgain.internal.ml.SecuredIgniteMl;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.ml.IgniteMl;
import org.gridgain.structure.IgniteStructures;

public class SecuredIgnite
implements Ignite,
Wrapper {
    private final Ignite delegate;
    private final SecuredIgniteTables tables;
    private final IgniteSql sql;
    private final IgniteCompute compute;
    private final IgniteMl ml;

    public SecuredIgnite(Ignite delegate, IgniteSql sql, IgniteCompute compute, IgniteMl ml, Authorizer authorizer, SecurityContext securityContext) {
        this.delegate = delegate;
        this.tables = new SecuredIgniteTables(delegate.tables(), delegate.caches(), authorizer, securityContext);
        this.sql = new SecuredIgniteSql(sql, securityContext);
        this.compute = new SecuredIgniteCompute(compute, securityContext);
        this.ml = new SecuredIgniteMl(ml, securityContext);
    }

    @Override
    public String name() {
        return this.delegate.name();
    }

    @Override
    public IgniteTables tables() {
        return this.tables;
    }

    @Override
    public IgniteCaches caches() {
        return this.tables;
    }

    @Override
    public IgniteTransactions transactions() {
        return this.delegate.transactions();
    }

    @Override
    public IgniteSql sql() {
        return this.sql;
    }

    @Override
    public IgniteCompute compute() {
        return this.compute;
    }

    @Override
    public Collection<ClusterNode> clusterNodes() {
        return this.delegate.clusterNodes();
    }

    @Override
    public CompletableFuture<Collection<ClusterNode>> clusterNodesAsync() {
        return this.delegate.clusterNodesAsync();
    }

    @Override
    public IgniteCatalog catalog() {
        return new IgniteCatalogSqlImpl(this.sql, this.tables, this.tables);
    }

    @Override
    public IgniteCluster cluster() {
        return this.delegate.cluster();
    }

    @Override
    public IgniteStructures structures() {
        return this.delegate.structures();
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        return Wrappers.unwrap(this.delegate, classToUnwrap);
    }

    @Override
    public IgniteMl ml() {
        return this.ml;
    }
}

