/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.compute.JobState;
import org.apache.ignite3.compute.TaskState;
import org.apache.ignite3.compute.task.TaskExecution;
import org.apache.ignite3.internal.compute.ComputeUtils;
import org.apache.ignite3.internal.compute.HybridTimestampProvider;
import org.apache.ignite3.internal.compute.MarshallerProvider;
import org.apache.ignite3.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite3.marshalling.Marshaller;
import org.jetbrains.annotations.Nullable;

class TaskExecutionFutureWrapper<R>
implements TaskExecution<R>,
MarshallerProvider<R>,
HybridTimestampProvider {
    private final CompletableFuture<TaskExecution<R>> delegate;

    TaskExecutionFutureWrapper(CompletableFuture<TaskExecution<R>> delegate) {
        this.delegate = delegate;
    }

    @Override
    public CompletableFuture<R> resultAsync() {
        return ComputeUtils.convertToComputeFuture(this.delegate.thenCompose(TaskExecution::resultAsync));
    }

    @Override
    public CompletableFuture<@Nullable TaskState> stateAsync() {
        return IgniteExceptionMapperUtil.convertToPublicFuture(this.delegate.thenCompose(TaskExecution::stateAsync));
    }

    @Override
    public CompletableFuture<@Nullable Boolean> changePriorityAsync(int newPriority) {
        return IgniteExceptionMapperUtil.convertToPublicFuture(this.delegate.thenCompose(jobExecution -> jobExecution.changePriorityAsync(newPriority)));
    }

    @Override
    public CompletableFuture<List<@Nullable JobState>> statesAsync() {
        return IgniteExceptionMapperUtil.convertToPublicFuture(this.delegate.thenCompose(TaskExecution::statesAsync));
    }

    @Override
    @Nullable
    public Marshaller<R, byte[]> resultMarshaller() {
        assert (this.delegate.isDone()) : "The future must be completed by the time you call `resultMarshaller`";
        return ((MarshallerProvider)((Object)this.delegate.join())).resultMarshaller();
    }

    @Override
    public boolean marshalResult() {
        assert (this.delegate.isDone()) : "The future must be completed by the time you call `marshalResult`";
        return ((MarshallerProvider)((Object)this.delegate.join())).marshalResult();
    }

    @Override
    public long hybridTimestamp() {
        assert (this.delegate.isDone()) : "The future must be completed by the time you call `hybridTimestamp`";
        return ((HybridTimestampProvider)((Object)this.delegate.join())).hybridTimestamp();
    }
}

