/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite3.Ignite;
import org.apache.ignite3.compute.JobExecutionContext;
import org.apache.ignite3.deployment.DeploymentUnitInfo;
import org.apache.ignite3.internal.deployunit.DisposableDeploymentUnit;
import org.apache.ignite3.internal.deployunit.loader.UnitsClassLoader;
import org.apache.ignite3.internal.util.Lazy;
import org.apache.ignite3.table.partition.Partition;
import org.jetbrains.annotations.Nullable;

public class JobExecutionContextImpl
implements JobExecutionContext {
    private final Ignite ignite;
    private final AtomicBoolean isInterrupted;
    private final UnitsClassLoader classLoader;
    @Nullable
    private final Partition partition;
    private final Lazy<Collection<DeploymentUnitInfo>> deploymentUnits;

    public JobExecutionContextImpl(Ignite ignite, AtomicBoolean isInterrupted, UnitsClassLoader classLoader, @Nullable Partition partition) {
        this.ignite = ignite;
        this.isInterrupted = isInterrupted;
        this.classLoader = classLoader;
        this.partition = partition;
        this.deploymentUnits = new Lazy<Collection>(this::initDeploymentUnits);
    }

    @Override
    public Ignite ignite() {
        return this.ignite;
    }

    @Override
    public boolean isCancelled() {
        return this.isInterrupted.get();
    }

    @Override
    @Nullable
    public Partition partition() {
        return this.partition;
    }

    @Override
    public Collection<DeploymentUnitInfo> deploymentUnits() {
        return this.deploymentUnits.get();
    }

    public UnitsClassLoader classLoader() {
        return this.classLoader;
    }

    private Collection<DeploymentUnitInfo> initDeploymentUnits() {
        List<DisposableDeploymentUnit> units = this.classLoader.units();
        ArrayList<DeploymentUnitInfo> result = new ArrayList<DeploymentUnitInfo>(units.size());
        for (DisposableDeploymentUnit unit : units) {
            result.add(new DeploymentUnitInfo(unit.unit().name(), unit.unit().version(), unit.path()));
        }
        return result;
    }
}

