/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cluster.management.network;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite3.internal.cluster.management.network.CmgMessageCallback;
import org.apache.ignite3.internal.cluster.management.network.messages.CancelInitMessage;
import org.apache.ignite3.internal.cluster.management.network.messages.ClusterStateMessage;
import org.apache.ignite3.internal.cluster.management.network.messages.CmgInitMessage;
import org.apache.ignite3.internal.cluster.management.network.messages.CmgMessagesFactory;
import org.apache.ignite3.internal.cluster.management.network.messages.CmgPrepareInitMessage;
import org.apache.ignite3.internal.cluster.management.network.messages.NodeStopMessage;
import org.apache.ignite3.internal.cluster.management.network.messages.RefuseJoinMessage;
import org.apache.ignite3.internal.failure.FailureContext;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.lang.NodeStoppingException;
import org.apache.ignite3.internal.network.ClusterService;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.network.NetworkMessage;
import org.apache.ignite3.internal.network.NetworkMessageHandler;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.jetbrains.annotations.Nullable;

public class CmgMessageHandler
implements NetworkMessageHandler {
    private final IgniteSpinBusyLock busyLock;
    private final CmgMessagesFactory msgFactory;
    private final ClusterService clusterService;
    private final FailureProcessor failureProcessor;
    private final CmgMessageCallback cmgMessageCallback;
    @Nullable
    private List<NetworkMessageContext> messageQueue = new ArrayList<NetworkMessageContext>();
    private final Object messageQueueMux = new Object();

    public CmgMessageHandler(IgniteSpinBusyLock busyLock, CmgMessagesFactory msgFactory, ClusterService clusterService, FailureProcessor failureProcessor, CmgMessageCallback cmgMessageCallback) {
        this.busyLock = busyLock;
        this.msgFactory = msgFactory;
        this.clusterService = clusterService;
        this.failureProcessor = failureProcessor;
        this.cmgMessageCallback = cmgMessageCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void onReceived(NetworkMessage message, InternalClusterNode sender, @Nullable Long correlationId) {
        if (!this.busyLock.enterBusy()) {
            if (correlationId == null) return;
            this.clusterService.messagingService().respond(sender, this.initFailed(new NodeStoppingException()), (long)correlationId);
            return;
        }
        try {
            Object object = this.messageQueueMux;
            // MONITORENTER : object
            if (this.messageQueue != null) {
                this.messageQueue.add(new NetworkMessageContext(message, sender, correlationId));
                // MONITOREXIT : object
                return;
            }
            // MONITOREXIT : object
            if (message instanceof ClusterStateMessage) {
                this.cmgMessageCallback.onClusterStateMessageReceived((ClusterStateMessage)message, sender, correlationId);
                return;
            }
            if (message instanceof CancelInitMessage) {
                this.cmgMessageCallback.onCancelInitMessageReceived((CancelInitMessage)message, sender, correlationId);
                return;
            }
            if (message instanceof RefuseJoinMessage) {
                this.cmgMessageCallback.onRefuseJoinMessageReceived((RefuseJoinMessage)message, sender, correlationId);
                return;
            }
            if (message instanceof CmgInitMessage) {
                this.cmgMessageCallback.onCmgInitMessageReceived((CmgInitMessage)message, sender, correlationId);
                return;
            }
            if (message instanceof CmgPrepareInitMessage) {
                this.cmgMessageCallback.onCmgPrepareInitMessageReceived((CmgPrepareInitMessage)message, sender, correlationId);
                return;
            }
            if (!(message instanceof NodeStopMessage)) return;
            this.cmgMessageCallback.onNodeStopMessageReceived((NodeStopMessage)message, sender, correlationId);
            return;
        }
        catch (Exception e) {
            this.failureProcessor.process(new FailureContext(e, "CMG message handling failed"));
            if (correlationId == null) return;
            this.clusterService.messagingService().respond(sender, this.initFailed(e), (long)correlationId);
            return;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRecoveryComplete() {
        Object object = this.messageQueueMux;
        synchronized (object) {
            assert (this.messageQueue != null);
            List<NetworkMessageContext> localQueue = this.messageQueue;
            this.messageQueue = null;
            for (NetworkMessageContext messageContext : localQueue) {
                this.onReceived(messageContext.message, messageContext.sender, messageContext.correlationId);
            }
        }
    }

    private NetworkMessage initFailed(Exception e) {
        return this.msgFactory.initErrorMessage().cause(e.getMessage()).build();
    }

    private static class NetworkMessageContext {
        final NetworkMessage message;
        final InternalClusterNode sender;
        @Nullable
        final Long correlationId;

        NetworkMessageContext(NetworkMessage message, InternalClusterNode sender, @Nullable Long correlationId) {
            this.message = message;
            this.sender = sender;
            this.correlationId = correlationId;
        }
    }
}

