/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cluster.management;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite3.internal.cluster.management.ClusterState;
import org.apache.ignite3.internal.cluster.management.ClusterStateV2;
import org.apache.ignite3.internal.cluster.management.ClusterTag;
import org.apache.ignite3.internal.cluster.management.network.messages.CmgMessagesFactory;
import org.apache.ignite3.internal.util.io.IgniteDataInput;
import org.apache.ignite3.internal.util.io.IgniteDataOutput;
import org.apache.ignite3.internal.versioned.VersionedSerializer;
import org.jetbrains.annotations.Nullable;

public class ClusterStatePersistentSerializer
extends VersionedSerializer<ClusterState> {
    private static final CmgMessagesFactory CMG_MSGS_FACTORY = new CmgMessagesFactory();
    public static final ClusterStatePersistentSerializer INSTANCE = new ClusterStatePersistentSerializer();

    @Override
    protected byte getProtocolVersion() {
        return 2;
    }

    @Override
    protected void writeExternalData(ClusterState state, IgniteDataOutput out) throws IOException {
        ClusterStatePersistentSerializer.writeStringSet(state.cmgNodes(), out);
        ClusterStatePersistentSerializer.writeStringSet(state.metaStorageNodes(), out);
        out.writeUTF(state.version());
        out.writeUTF(state.clusterTag().clusterName());
        out.writeUuid(state.clusterTag().clusterId());
        ClusterStatePersistentSerializer.writeNullableString(state.initialClusterConfiguration(), out);
        List<UUID> formerClusterIds = state.formerClusterIds();
        out.writeVarInt(formerClusterIds == null ? -1L : (long)formerClusterIds.size());
        if (formerClusterIds != null) {
            for (UUID clusterId : formerClusterIds) {
                out.writeUuid(clusterId);
            }
        }
        if (state instanceof ClusterStateV2) {
            ClusterStatePersistentSerializer.writeNullableString(((ClusterStateV2)state).nextVersion(), out);
        } else {
            ClusterStatePersistentSerializer.writeNullableString(null, out);
        }
    }

    @Override
    protected ClusterState readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        Set<String> cmgNodes = ClusterStatePersistentSerializer.readStringSet(in);
        Set<String> metaStorageNodes = ClusterStatePersistentSerializer.readStringSet(in);
        String version = in.readUTF();
        ClusterTag clusterTag = ClusterTag.clusterTag(CMG_MSGS_FACTORY, in.readUTF(), in.readUuid());
        String initialClusterConfiguration = ClusterStatePersistentSerializer.readNullableString(in);
        List<UUID> formerClusterIds = ClusterStatePersistentSerializer.readFormerClusterIds(in);
        String nextVersion = ClusterStatePersistentSerializer.readNextVersion(protoVer, in);
        return CMG_MSGS_FACTORY.clusterStateV2().cmgNodes(cmgNodes).metaStorageNodes(metaStorageNodes).version(version).clusterTag(clusterTag).initialClusterConfiguration(initialClusterConfiguration).formerClusterIds(formerClusterIds).nextVersion(nextVersion).build();
    }

    @Nullable
    private static List<UUID> readFormerClusterIds(IgniteDataInput in) throws IOException {
        int length = in.readVarIntAsInt();
        if (length == -1) {
            return null;
        }
        ArrayList<UUID> result = new ArrayList<UUID>(length);
        for (int i = 0; i < length; ++i) {
            result.add(in.readUuid());
        }
        return result;
    }

    @Nullable
    private static String readNextVersion(byte protoVer, IgniteDataInput in) throws IOException {
        return protoVer > 1 ? ClusterStatePersistentSerializer.readNullableString(in) : null;
    }
}

