/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.client.io.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.ignite3.internal.client.io.netty.NettyClientConnection;

public class NettyClientMessageHandler
extends ChannelInboundHandlerAdapter {
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        NettyClientMessageHandler.connection(ctx).onMessage((ByteBuf)msg);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        NettyClientMessageHandler.connection(ctx).onDisconnected(null);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        NettyClientMessageHandler.connection(ctx).onDisconnected(cause);
        ctx.channel().close();
    }

    private static NettyClientConnection connection(ChannelHandlerContext ctx) {
        return (NettyClientConnection)ctx.channel().attr(NettyClientConnection.ATTR_CONN).get();
    }
}

