/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.client.io.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import org.apache.ignite3.internal.client.ClientMetricSource;
import org.apache.ignite3.internal.client.io.ClientConnection;
import org.apache.ignite3.internal.client.io.ClientConnectionStateHandler;
import org.apache.ignite3.internal.client.io.ClientMessageHandler;
import org.apache.ignite3.lang.IgniteException;
import org.jetbrains.annotations.Nullable;

public class NettyClientConnection
implements ClientConnection {
    static final AttributeKey<NettyClientConnection> ATTR_CONN = AttributeKey.newInstance((String)"CONN");
    private final InetSocketAddress addr;
    private final Channel channel;
    private final ClientMessageHandler msgHnd;
    private final ClientConnectionStateHandler stateHnd;
    private final ClientMetricSource metrics;

    NettyClientConnection(InetSocketAddress addr, Channel channel, ClientMessageHandler msgHnd, ClientConnectionStateHandler stateHnd, ClientMetricSource metrics) {
        this.addr = addr;
        this.channel = channel;
        this.msgHnd = msgHnd;
        this.stateHnd = stateHnd;
        this.metrics = metrics;
        channel.attr(ATTR_CONN).set((Object)this);
    }

    @Override
    public ChannelFuture send(ByteBuf msg) throws IgniteException {
        int bytes = msg.readableBytes();
        ChannelFuture fut = this.channel.writeAndFlush((Object)msg);
        this.metrics.bytesSentAdd(bytes);
        return fut;
    }

    @Override
    public ByteBuf getBuffer() {
        return this.channel.alloc().buffer();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return this.addr;
    }

    @Override
    public void close() {
        this.channel.close();
    }

    void onMessage(ByteBuf buf) {
        this.metrics.bytesReceivedAdd(buf.readableBytes());
        this.msgHnd.onMessage(buf);
    }

    void onDisconnected(@Nullable Throwable e) {
        this.stateHnd.onDisconnected(e);
    }
}

