/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.rest;

import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.config.ConfigManagerProvider;
import org.apache.ignite3.internal.cli.event.ConnectionEventListener;
import org.jetbrains.annotations.Nullable;

@Singleton
public class TokenStore
implements ConnectionEventListener {
    private final ConfigManagerProvider configManagerProvider;
    private volatile String token;

    public TokenStore(ConfigManagerProvider configManagerProvider) {
        this.configManagerProvider = configManagerProvider;
    }

    public void setToken(String token) {
        this.token = token;
    }

    @Nullable
    public String getCurrentToken() {
        return this.token != null ? this.token : this.configManagerProvider.get().getCurrentProperty("ignite.auth.token");
    }

    @Override
    public void onDisconnect() {
        this.token = null;
    }

    public boolean isTokenPersisted() {
        return this.configManagerProvider.get().getCurrentProperty("ignite.auth.token") != null;
    }
}

