/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.exception.handler;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.net.ssl.SSLHandshakeException;
import org.apache.ignite3.client.IgniteClientConnectionException;
import org.apache.ignite3.internal.cli.core.exception.ExceptionHandler;
import org.apache.ignite3.internal.cli.core.exception.ExceptionWriter;
import org.apache.ignite3.internal.cli.core.style.component.ErrorUiComponent;
import org.apache.ignite3.internal.cli.core.style.element.UiElement;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteCheckedException;
import org.apache.ignite3.lang.IgniteException;
import org.apache.ignite3.security.exception.InvalidCredentialsException;
import org.jetbrains.annotations.Nullable;

public class SqlExceptionHandler
implements ExceptionHandler<SQLException> {
    public static final SqlExceptionHandler INSTANCE = new SqlExceptionHandler();
    private static final IgniteLogger LOG = Loggers.forClass(SqlExceptionHandler.class);
    private static final String CLIENT_CONNECTION_FAILED_MESSAGE = "Connection failed";
    private static final String UNRECOGNIZED_ERROR_MESSAGE = "Unrecognized error while processing SQL query ";
    private final Map<Short, Function<IgniteException, ErrorUiComponent>> sqlExceptionMappers = new HashMap<Short, Function<IgniteException, ErrorUiComponent>>();

    private SqlExceptionHandler() {
        this.sqlExceptionMappers.put(ErrorGroups.Client.CLIENT_ERR_GROUP.groupCode(), SqlExceptionHandler::connectionErrUiComponent);
        this.sqlExceptionMappers.put(ErrorGroups.Sql.SQL_ERR_GROUP.groupCode(), SqlExceptionHandler::sqlErrUiComponent);
    }

    private static ErrorUiComponent connectionErrUiComponent(IgniteException e) {
        if (e.code() != ErrorGroups.Client.CONNECTION_ERR) {
            return SqlExceptionHandler.fromIgniteException("Client error", e);
        }
        if (e.getCause() instanceof IgniteClientConnectionException) {
            IgniteClientConnectionException cause = (IgniteClientConnectionException)e.getCause();
            InvalidCredentialsException invalidCredentialsException = SqlExceptionHandler.findCause(cause, InvalidCredentialsException.class);
            if (invalidCredentialsException != null) {
                return ErrorUiComponent.builder().header("Could not connect to node. Check authentication configuration", new UiElement[0]).details(invalidCredentialsException.getMessage(), new UiElement[0]).verbose(ErrorGroups.extractCauseMessage(cause.getMessage()), new UiElement[0]).build();
            }
            SSLHandshakeException sslHandshakeException = SqlExceptionHandler.findCause(cause, SSLHandshakeException.class);
            if (sslHandshakeException != null) {
                return ErrorUiComponent.builder().header("Could not connect to node. Check SSL configuration", new UiElement[0]).details(sslHandshakeException.getMessage(), new UiElement[0]).verbose(ErrorGroups.extractCauseMessage(cause.getMessage()), new UiElement[0]).build();
            }
            return SqlExceptionHandler.fromIgniteException(CLIENT_CONNECTION_FAILED_MESSAGE, cause);
        }
        return SqlExceptionHandler.fromIgniteException(CLIENT_CONNECTION_FAILED_MESSAGE, e);
    }

    @Nullable
    private static <T extends Throwable> T findCause(Throwable e, Class<T> type) {
        while (e != null) {
            if (type.isInstance(e)) {
                return (T)e;
            }
            e = e.getCause();
        }
        return null;
    }

    @Override
    public int handle(ExceptionWriter err, SQLException e) {
        ErrorUiComponent errorComponent;
        Throwable unwrappedCause = ExceptionUtils.unwrapCause(e.getCause());
        if (unwrappedCause instanceof IgniteException) {
            IgniteException igniteException = (IgniteException)unwrappedCause;
            errorComponent = this.sqlExceptionMappers.getOrDefault(igniteException.groupCode(), SqlExceptionHandler::otherIgniteException).apply(igniteException);
        } else if (unwrappedCause instanceof IgniteCheckedException) {
            IgniteCheckedException checkedError = (IgniteCheckedException)unwrappedCause;
            errorComponent = SqlExceptionHandler.fromCheckedIgniteException(UNRECOGNIZED_ERROR_MESSAGE, checkedError);
        } else {
            LOG.warn("Unrecognized exception", (Throwable)e);
            errorComponent = ErrorUiComponent.builder().header("Unrecognized exception", new UiElement[0]).details(String.valueOf(unwrappedCause), new UiElement[0]).build();
        }
        err.write(errorComponent.render());
        return 1;
    }

    private static ErrorUiComponent sqlErrUiComponent(IgniteException e) {
        String header = e.code() == ErrorGroups.Sql.STMT_PARSE_ERR ? "SQL query parsing error" : (e.code() == ErrorGroups.Sql.STMT_VALIDATION_ERR ? "SQL query validation error" : (e.code() == ErrorGroups.Sql.CONSTRAINT_VIOLATION_ERR ? "Constraint violation" : (e.code() == ErrorGroups.Sql.EXECUTION_CANCELLED_ERR ? "Query was cancelled" : (e.code() == ErrorGroups.Sql.RUNTIME_ERR ? "SQL query execution error" : (e.code() == ErrorGroups.Sql.MAPPING_ERR ? "Unable to map query on current cluster topology" : (e.code() == ErrorGroups.Sql.TX_CONTROL_INSIDE_EXTERNAL_TX_ERR ? "Unexpected SQL statement" : "SQL error"))))));
        return SqlExceptionHandler.fromIgniteException(header, e);
    }

    private static ErrorUiComponent fromIgniteException(String header, IgniteException e) {
        return ErrorUiComponent.builder().header(header, new UiElement[0]).errorCode(String.valueOf(e.code())).traceId(e.traceId()).details(e.codeAsString() + ": " + ErrorGroups.extractCauseMessage(e.getMessage()), new UiElement[0]).build();
    }

    private static ErrorUiComponent fromCheckedIgniteException(String header, IgniteCheckedException e) {
        return ErrorUiComponent.builder().header(header, new UiElement[0]).errorCode(String.valueOf(e.code())).traceId(e.traceId()).details(e.codeAsString() + ": " + ErrorGroups.extractCauseMessage(e.getMessage()), new UiElement[0]).build();
    }

    private static ErrorUiComponent otherIgniteException(IgniteException e) {
        return SqlExceptionHandler.fromIgniteException(e.groupName() + " error", e);
    }

    @Override
    public Class<SQLException> applicableException() {
        return SQLException.class;
    }
}

