/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.config.ini;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class IniSection {
    private final String name;
    private final Map<String, String> props = new LinkedHashMap<String, String>();

    public IniSection(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getAll() {
        return Collections.unmodifiableMap(this.props);
    }

    public String getProperty(String key) {
        return this.props.get(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.props.getOrDefault(key, defaultValue);
    }

    public void setProperty(String key, String value) {
        this.props.put(key, value);
    }

    public String removeProperty(String key) {
        return this.props.remove(key);
    }

    public void setProperties(Map<String, String> values) {
        this.props.putAll(values);
    }
}

