/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.call.recovery.reset;

import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.call.recovery.reset.ResetPartitionsCallInput;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.RecoveryApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.ResetZonePartitionsRequest;

@Singleton
public class ResetPartitionsCall
implements Call<ResetPartitionsCallInput, String> {
    private final ApiClientFactory clientFactory;

    public ResetPartitionsCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public DefaultCallOutput<String> execute(ResetPartitionsCallInput input) {
        RecoveryApi client = new RecoveryApi(this.clientFactory.getClient(input.clusterUrl()));
        try {
            ResetZonePartitionsRequest command = new ResetZonePartitionsRequest();
            command.setPartitionIds(input.partitionIds());
            command.setZoneName(input.zoneName());
            client.resetZonePartitions(command);
            return DefaultCallOutput.success("Successfully reset partitions.");
        }
        catch (ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.clusterUrl()));
        }
    }
}

