/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.call.configuration;

import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.call.configuration.ClusterConfigUpdateCallInput;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.ClusterConfigurationApi;
import org.apache.ignite3.rest.client.invoker.ApiException;

@Singleton
public class ClusterConfigUpdateCall
implements Call<ClusterConfigUpdateCallInput, String> {
    private final ApiClientFactory clientFactory;

    public ClusterConfigUpdateCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public DefaultCallOutput<String> execute(ClusterConfigUpdateCallInput input) {
        ClusterConfigurationApi client = this.createApiClient(input);
        try {
            return this.updateClusterConfig(client, input);
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.getClusterUrl()));
        }
    }

    private DefaultCallOutput<String> updateClusterConfig(ClusterConfigurationApi api, ClusterConfigUpdateCallInput input) throws ApiException {
        api.updateClusterConfiguration(input.getConfig());
        return DefaultCallOutput.success("Cluster configuration was updated successfully");
    }

    private ClusterConfigurationApi createApiClient(ClusterConfigUpdateCallInput input) {
        return new ClusterConfigurationApi(this.clientFactory.getClient(input.getClusterUrl()));
    }
}

