/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSystemViewDescriptor;
import org.apache.ignite3.internal.catalog.events.CatalogEvent;
import org.apache.ignite3.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite3.internal.catalog.events.CreateSystemViewEventParameters;
import org.apache.ignite3.internal.catalog.storage.Fireable;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.tostring.S;

public class NewSystemViewEntry
implements UpdateEntry,
Fireable {
    private final CatalogSystemViewDescriptor descriptor;

    public NewSystemViewEntry(CatalogSystemViewDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public CatalogSystemViewDescriptor descriptor() {
        return this.descriptor;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.NEW_SYS_VIEW.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.SYSTEM_VIEW_CREATE;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new CreateSystemViewEventParameters(causalityToken, catalogVersion, this.descriptor);
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, HybridTimestamp timestamp) {
        CatalogSchemaDescriptor systemSchema = CatalogUtils.schemaOrThrow(catalog, this.descriptor.schemaId());
        this.descriptor.updateTimestamp(timestamp);
        Map systemViews = Arrays.stream(systemSchema.systemViews()).collect(Collectors.toMap(CatalogObjectDescriptor::name, Function.identity()));
        systemViews.put(this.descriptor.name(), this.descriptor);
        CatalogSystemViewDescriptor[] sysViewArray = systemViews.values().toArray(new CatalogSystemViewDescriptor[0]);
        CatalogSchemaDescriptor newSystemSchema = new CatalogSchemaDescriptor(systemSchema.id(), systemSchema.name(), systemSchema.tables(), systemSchema.indexes(), sysViewArray, systemSchema.sequences(), systemSchema.policies(), systemSchema.maps(), systemSchema.statistics(), timestamp);
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones(), CatalogUtils.replaceSchema(newSystemSchema, catalog.schemas()), CatalogUtils.defaultZoneIdOpt(catalog));
    }

    public String toString() {
        return S.toString(this);
    }
}

