/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.descriptors;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Objects;
import org.apache.ignite3.internal.catalog.CatalogManager;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public class CatalogHashIndexDescriptor
extends CatalogIndexDescriptor {
    @Nullable
    private final IntList columnIds;
    @Nullable
    private final List<String> columnNames;

    @Deprecated(forRemoval=true)
    public CatalogHashIndexDescriptor(int id, String name, int tableId, boolean unique, CatalogIndexStatus status, List<String> columnNames, boolean isCreatedWithTable) {
        this(id, name, tableId, unique, status, columnNames, null, CatalogManager.INITIAL_TIMESTAMP, isCreatedWithTable);
    }

    public CatalogHashIndexDescriptor(int id, String name, int tableId, boolean unique, CatalogIndexStatus status, IntList columnIds, boolean isCreatedWithTable) {
        this(id, name, tableId, unique, status, null, columnIds, CatalogManager.INITIAL_TIMESTAMP, isCreatedWithTable);
    }

    CatalogHashIndexDescriptor(int id, String name, int tableId, boolean unique, CatalogIndexStatus status, @Nullable List<String> columnNames, @Nullable IntList columnIds, HybridTimestamp timestamp, boolean isCreatedWithTable) {
        super(CatalogIndexDescriptor.CatalogIndexDescriptorType.HASH, id, name, tableId, unique, status, timestamp, isCreatedWithTable);
        this.columnIds = columnIds;
        this.columnNames = CollectionUtils.copyOrNull(columnNames);
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public List<String> columns() {
        return this.columnNames;
    }

    @Override
    public CatalogHashIndexDescriptor upgradeIfNeeded(CatalogTableDescriptor table) {
        if (this.columnIds != null) {
            return this;
        }
        assert (this.tableId() == table.id());
        assert (this.columnNames != null);
        int[] columnIds = new int[this.columnNames.size()];
        for (int i = 0; i < columnIds.length; ++i) {
            CatalogTableColumnDescriptor column = table.column(this.columnNames.get(i));
            assert (column != null) : this.columnNames.get(i);
            columnIds[i] = column.id();
        }
        return new CatalogHashIndexDescriptor(this.id(), this.name(), this.tableId(), this.unique(), this.status(), null, IntList.of((int[])columnIds), this.updateTimestamp(), this.isCreatedWithTable());
    }

    public IntList columnIds() {
        return Objects.requireNonNull(this.columnIds);
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.DESCRIPTOR_HASH_INDEX.id();
    }

    @Override
    public String toString() {
        return S.toString(CatalogHashIndexDescriptor.class, this, super.toString());
    }
}

