/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.app;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.catalog.CatalogService;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lowwatermark.LowWatermark;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.manager.IgniteComponent;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.jetbrains.annotations.Nullable;

class LowWatermarkRectifier
implements IgniteComponent {
    private final LowWatermark lowWatermark;
    private final CatalogService catalogService;

    LowWatermarkRectifier(LowWatermark lowWatermark, CatalogService catalogService) {
        this.lowWatermark = lowWatermark;
        this.catalogService = catalogService;
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        HybridTimestamp earliestCatalogTimestamp = HybridTimestamp.hybridTimestamp(this.catalogService.earliestCatalog().time());
        @Nullable HybridTimestamp lwm = this.lowWatermark.getLowWatermark();
        if (lwm != null && lwm.compareTo(earliestCatalogTimestamp) < 0) {
            this.lowWatermark.setLowWatermarkOnRecovery(earliestCatalogTimestamp);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        return CompletableFutures.nullCompletedFuture();
    }
}

