/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler.requests.table;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.client.handler.ClientResourceRegistry;
import org.apache.ignite3.client.handler.NotificationSender;
import org.apache.ignite3.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite3.client.handler.requests.table.ClientTupleRequestBase;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.hlc.HybridTimestampTracker;
import org.apache.ignite3.internal.table.IgniteTablesInternal;
import org.apache.ignite3.internal.table.TableViewInternal;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.tx.TxManager;
import org.apache.ignite3.table.Tuple;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.jetbrains.annotations.Nullable;

class ClientTuplesRequestBase {
    private final InternalTransaction tx;
    private final TableViewInternal table;
    private final List<Tuple> tuples;
    private final long resourceId;

    private ClientTuplesRequestBase(InternalTransaction tx, TableViewInternal table, List<Tuple> tuples, long resourceId) {
        this.tx = tx;
        this.table = table;
        this.tuples = tuples;
        this.resourceId = resourceId;
    }

    public InternalTransaction tx() {
        return this.tx;
    }

    public long resourceId() {
        return this.resourceId;
    }

    public TableViewInternal table() {
        return this.table;
    }

    public List<Tuple> tuples() {
        return this.tuples;
    }

    public static CompletableFuture<ClientTuplesRequestBase> readAsync(ClientMessageUnpacker in, IgniteTablesInternal tables, ClientResourceRegistry resources, TxManager txManager, @Nullable NotificationSender notificationSender, LicenseFeatureChecker licenseFeatureChecker, HybridTimestampTracker tsTracker, EnumSet<ClientTupleRequestBase.RequestOptions> options) {
        int tableId = in.unpackInt();
        long[] resIdHolder = new long[]{0L};
        CompletableFuture<InternalTransaction> txFut = ClientTableCommon.readOrStartImplicitTx(in, tsTracker, resources, txManager, tables, options, notificationSender, licenseFeatureChecker, resIdHolder);
        int schemaId = in.unpackInt();
        int count = in.unpackInt();
        BitSet[] noValueSet = new BitSet[count];
        byte[][] tupleBytes = new byte[count][];
        for (int i = 0; i < count; ++i) {
            noValueSet[i] = in.unpackBitSet();
            tupleBytes[i] = in.readBinary();
        }
        return txFut.thenCompose(tx -> ClientTableCommon.readTableAsync(tableId, tables).thenCompose(table -> ClientTableCommon.readSchema(schemaId, table).thenApply(schema -> {
            ArrayList<Tuple> tuples = new ArrayList<Tuple>(count);
            for (int i = 0; i < count; ++i) {
                tuples.add(ClientTableCommon.readTuple(noValueSet[i], tupleBytes[i], options.contains((Object)ClientTupleRequestBase.RequestOptions.KEY_ONLY), schema));
            }
            return new ClientTuplesRequestBase((InternalTransaction)tx, (TableViewInternal)table, (List<Tuple>)tuples, resIdHolder[0]);
        })));
    }
}

