/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler.requests.table;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.client.handler.ResponseWriter;
import org.apache.ignite3.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite3.internal.client.proto.ClientMessagePacker;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.continuousquery.ContinuousQueryRequest;
import org.apache.ignite3.internal.continuousquery.ContinuousQueryScanResultStatus;
import org.apache.ignite3.internal.continuousquery.RowUpdateInfo;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.table.IgniteTablesInternal;
import org.apache.ignite3.lang.TableNotFoundException;
import org.jetbrains.annotations.Nullable;

public class ClientContinuousQueryScanRequest {
    public static CompletableFuture<ResponseWriter> process(ClientMessageUnpacker in, IgniteTablesInternal tables, boolean packEventTypeId, boolean partitionScanStatus, boolean supportsSkipOldEntriesFlag) {
        int tableId = in.unpackInt();
        int partId = in.unpackInt();
        long lowerBoundTs = in.unpackLong();
        UUID lowerBoundRowId = in.unpackUuid();
        int maxItems = in.unpackInt();
        byte eventTypes = in.unpackByte();
        String[] columnNames = ClientContinuousQueryScanRequest.readColumnNames(in);
        boolean skipOldEntries = supportsSkipOldEntriesFlag && in.unpackBoolean();
        ContinuousQueryRequest req = new ContinuousQueryRequest(partId, lowerBoundTs, lowerBoundRowId, maxItems, eventTypes, columnNames, skipOldEntries);
        return ClientTableCommon.readTableAsync(tableId, tables).thenCompose(table -> table.sendContinuousQueryRequest(req).thenApply(result -> out -> {
            if (!partitionScanStatus && result.result().status() == ContinuousQueryScanResultStatus.END_OF_LOG_REACHED_TABLE_DROPPED) {
                throw new TableNotFoundException(table.qualifiedName());
            }
            out.packLong(result.result().safeTime());
            out.packInt(result.result().schemaVersion());
            out.packInt(result.result().rows().size());
            for (RowUpdateInfo rowInfo : result.result().rows()) {
                out.packUuid(rowInfo.rowUuid());
                out.packLong(rowInfo.timestamp().longValue());
                ClientContinuousQueryScanRequest.packBinaryRow(out, (BinaryRow)rowInfo.oldRow());
                ClientContinuousQueryScanRequest.packBinaryRow(out, (BinaryRow)rowInfo.row());
                if (!packEventTypeId) continue;
                out.packInt(rowInfo.eventType().id());
            }
            if (partitionScanStatus) {
                out.packByte(result.result().status().id());
            }
        }));
    }

    private static String @Nullable [] readColumnNames(ClientMessageUnpacker in) {
        if (in.tryUnpackNil()) {
            return null;
        }
        int columnNamesSize = in.unpackInt();
        String[] columnNames = new String[columnNamesSize];
        for (int i = 0; i < columnNamesSize; ++i) {
            columnNames[i] = in.unpackString();
        }
        return columnNames;
    }

    private static void packBinaryRow(ClientMessagePacker out, @Nullable BinaryRow binaryRow) {
        if (binaryRow == null) {
            out.packNil();
        } else {
            out.packBinaryHeader(binaryRow.tupleSliceLength());
            out.writePayload(binaryRow.tupleSlice());
        }
    }
}

