/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler.requests.compute;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.ignite3.client.handler.ClientContext;
import org.apache.ignite3.client.handler.NotificationSender;
import org.apache.ignite3.client.handler.ResponseWriter;
import org.apache.ignite3.client.handler.requests.compute.ClientComputeGetStateRequest;
import org.apache.ignite3.compute.JobState;
import org.apache.ignite3.compute.TaskDescriptor;
import org.apache.ignite3.compute.task.TaskExecution;
import org.apache.ignite3.deployment.DeploymentUnit;
import org.apache.ignite3.internal.client.proto.ClientComputeJobPacker;
import org.apache.ignite3.internal.client.proto.ClientComputeJobUnpacker;
import org.apache.ignite3.internal.client.proto.ClientMessagePacker;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.compute.ComputeJobDataHolder;
import org.apache.ignite3.internal.compute.HybridTimestampProvider;
import org.apache.ignite3.internal.compute.IgniteComputeInternal;
import org.apache.ignite3.internal.compute.MarshallerProvider;
import org.apache.ignite3.internal.compute.events.ComputeEventMetadata;
import org.apache.ignite3.internal.compute.events.ComputeEventMetadataBuilder;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.marshalling.Marshaller;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.internal.security.context.SecurityContextHolder;

public class ClientComputeExecuteMapReduceRequest {
    private static final IgniteLogger LOG = Loggers.forClass(ClientComputeExecuteMapReduceRequest.class);

    public static CompletableFuture<ResponseWriter> process(ClientMessageUnpacker in, IgniteComputeInternal compute, NotificationSender notificationSender, ClientContext clientContext) {
        List<DeploymentUnit> deploymentUnits = in.unpackDeploymentUnits();
        String taskClassName = in.unpackString();
        SecurityContext securityContext = SecurityContextHolder.getOrThrow();
        ComputeJobDataHolder arg = ClientComputeJobUnpacker.unpackJobArgumentWithoutMarshaller(in);
        TaskDescriptor taskDescriptor = TaskDescriptor.builder(taskClassName).units(deploymentUnits).build();
        ComputeEventMetadataBuilder metadataBuilder = ComputeEventMetadata.builder(ComputeEventMetadata.Type.MAP_REDUCE).eventUser(clientContext.userDetails()).clientAddress(clientContext.remoteAddress().toString());
        TaskExecution<Object> execution = compute.submitMapReduceInternal(taskDescriptor, metadataBuilder, securityContext, arg, null);
        ClientComputeExecuteMapReduceRequest.sendTaskResult(execution, notificationSender);
        CompletionStage idsAsync = execution.idsAsync().handle((ids, ex) -> ex == null ? ids : Collections.emptyList());
        return execution.idAsync().thenCompose(arg_0 -> ClientComputeExecuteMapReduceRequest.lambda$process$3((CompletableFuture)idsAsync, arg_0));
    }

    private static void packJobIds(ClientMessagePacker out, List<UUID> ids) {
        out.packInt(ids.size());
        for (UUID uuid : ids) {
            out.packUuid(uuid);
        }
    }

    private static void sendTaskResult(TaskExecution<Object> execution, NotificationSender notificationSender) {
        execution.resultAsync().whenComplete((val, err) -> execution.stateAsync().whenComplete((state, errState) -> execution.statesAsync().whenComplete((states, errStates) -> {
            try {
                notificationSender.sendNotification(w -> {
                    Marshaller resultMarshaller = ((MarshallerProvider)((Object)execution)).resultMarshaller();
                    ClientComputeJobPacker.packJobResult(val, resultMarshaller, w);
                    ClientComputeGetStateRequest.packTaskState(w, state);
                    ClientComputeExecuteMapReduceRequest.packJobStates(w, states);
                }, IgniteUtils.firstNotNull(err, errState, errStates), ((HybridTimestampProvider)((Object)execution)).hybridTimestamp());
            }
            catch (Throwable t) {
                LOG.error("Failed to send task result notification: " + t.getMessage(), t);
            }
        })));
    }

    private static void packJobStates(ClientMessagePacker w, List<JobState> states) {
        w.packInt(states.size());
        for (JobState state : states) {
            ClientComputeGetStateRequest.packJobState(w, state);
        }
    }

    private static /* synthetic */ CompletionStage lambda$process$3(CompletableFuture idsAsync, UUID id) {
        return idsAsync.thenApply(ids -> out -> {
            out.packUuid(id);
            ClientComputeExecuteMapReduceRequest.packJobIds(out, ids);
        });
    }
}

