/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler.requests.compute;

import java.util.BitSet;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.client.handler.ClientContext;
import org.apache.ignite3.client.handler.NotificationSender;
import org.apache.ignite3.client.handler.ResponseWriter;
import org.apache.ignite3.client.handler.requests.compute.ClientComputeExecuteRequest;
import org.apache.ignite3.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite3.compute.JobExecution;
import org.apache.ignite3.internal.client.proto.ClientComputeJobUnpacker;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.client.proto.ProtocolBitmaskFeature;
import org.apache.ignite3.internal.compute.ComputeJobDataHolder;
import org.apache.ignite3.internal.compute.ExecutionContext;
import org.apache.ignite3.internal.compute.IgniteComputeInternal;
import org.apache.ignite3.internal.compute.events.ComputeEventMetadata;
import org.apache.ignite3.internal.compute.events.ComputeEventMetadataBuilder;
import org.apache.ignite3.internal.network.ClusterService;
import org.apache.ignite3.internal.table.IgniteTablesInternal;
import org.apache.ignite3.internal.table.TableViewInternal;
import org.apache.ignite3.table.Tuple;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.internal.security.context.SecurityContextHolder;

public class ClientComputeExecuteColocatedRequest {
    public static CompletableFuture<ResponseWriter> process(ClientMessageUnpacker in, IgniteComputeInternal compute, IgniteTablesInternal tables, ClusterService cluster, NotificationSender notificationSender, ClientContext clientContext) {
        SecurityContext securityContext = SecurityContextHolder.getOrThrow();
        int tableId = in.unpackInt();
        int schemaId = in.unpackInt();
        BitSet noValueSet = in.unpackBitSet();
        byte[] tupleBytes = in.readBinary();
        ClientComputeJobUnpacker.Job job = ClientComputeJobUnpacker.unpackJob(in, clientContext.hasFeature(ProtocolBitmaskFeature.PLATFORM_COMPUTE_JOB));
        ClientComputeJobUnpacker.unpackTaskId(in, clientContext.hasFeature(ProtocolBitmaskFeature.COMPUTE_TASK_ID));
        return ClientTableCommon.readTableAsync(tableId, tables).thenCompose(table -> ClientTableCommon.readTuple(schemaId, noValueSet, tupleBytes, table, true).thenCompose(keyTuple -> {
            ComputeEventMetadataBuilder metadataBuilder = ComputeEventMetadata.builder(ComputeEventMetadata.Type.SINGLE).eventUser(clientContext.userDetails()).tableName(table.name()).clientAddress(clientContext.remoteAddress().toString());
            CompletableFuture<JobExecution<ComputeJobDataHolder>> jobExecutionFut = compute.submitColocatedInternal((TableViewInternal)table, (Tuple)keyTuple, new ExecutionContext(job.options(), job.deploymentUnits(), job.jobClassName(), metadataBuilder, securityContext, job.arg()), null);
            ClientComputeExecuteRequest.sendResultAndState(jobExecutionFut, notificationSender);
            return jobExecutionFut.thenCompose(execution -> execution.idAsync().thenApply(jobId -> out -> {
                out.packInt(table.schemaView().lastKnownSchemaVersion());
                ClientComputeExecuteRequest.packSubmitResult(out, jobId, execution.node());
            }));
        }));
    }
}

